/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.crest;

import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.tomitribe.crest.BashCompletion;
import org.tomitribe.crest.api.Exit;
import org.tomitribe.crest.api.PrintOutput;
import org.tomitribe.crest.api.StreamingOutput;
import org.tomitribe.crest.api.interceptor.CrestInterceptor;
import org.tomitribe.crest.cmds.Cmd;
import org.tomitribe.crest.cmds.CommandFailedException;
import org.tomitribe.crest.cmds.Completer;
import org.tomitribe.crest.cmds.HelpPrintedException;
import org.tomitribe.crest.cmds.processors.Commands;
import org.tomitribe.crest.cmds.processors.Help;
import org.tomitribe.crest.contexts.DefaultsContext;
import org.tomitribe.crest.contexts.SystemPropertiesDefaultsContext;
import org.tomitribe.crest.environments.Environment;
import org.tomitribe.crest.environments.SystemEnvironment;
import org.tomitribe.crest.interceptor.internal.InternalInterceptor;
import org.tomitribe.crest.table.Formatting;
import org.tomitribe.crest.table.TableInterceptor;

public class Main
implements Completer {
    protected final Map<String, Cmd> commands = new ConcurrentHashMap<String, Cmd>();
    protected final Map<Class<?>, InternalInterceptor> interceptors = new HashMap();

    public Main() {
        this((DefaultsContext)new SystemPropertiesDefaultsContext(), Commands.load());
    }

    public Main(Class<?> ... classes) {
        this(Arrays.asList(classes));
    }

    public Main(DefaultsContext defaultsContext, Class<?> ... classes) {
        this(defaultsContext, Arrays.asList(classes));
    }

    public Main(DefaultsContext defaultsContext, Iterable<Class<?>> classes) {
        for (Class<?> clazz : classes) {
            this.processClass(defaultsContext, clazz);
        }
        this.processClass(defaultsContext, TableInterceptor.class);
        this.installHelp(defaultsContext);
    }

    public void processClass(DefaultsContext defaultsContext, Class<?> clazz) {
        Map<String, Cmd> m = Commands.get(clazz, defaultsContext);
        if (!m.isEmpty()) {
            this.commands.putAll(m);
        } else {
            InternalInterceptor internalInterceptor = InternalInterceptor.from(clazz);
            if (this.interceptors.put(clazz, internalInterceptor) != null) {
                throw new IllegalArgumentException(clazz + " interceptor is conflicting");
            }
            for (Annotation annotation : clazz.getDeclaredAnnotations()) {
                if (!Main.isCustomInterceptorAnnotation(annotation) || this.interceptors.put(annotation.annotationType(), internalInterceptor) == null) continue;
                throw new IllegalArgumentException(clazz + " interceptor is conflicting");
            }
        }
    }

    private static boolean isCustomInterceptorAnnotation(Annotation annotation) {
        for (Annotation declaredAnnotation : annotation.annotationType().getDeclaredAnnotations()) {
            if (!(declaredAnnotation instanceof CrestInterceptor)) continue;
            return true;
        }
        return false;
    }

    public Main(Iterable<Class<?>> classes) {
        this((DefaultsContext)new SystemPropertiesDefaultsContext(), classes);
    }

    public void add(Cmd cmd) {
        this.commands.put(cmd.getName(), cmd);
    }

    public void remove(Cmd cmd) {
        this.commands.remove(cmd.getName());
    }

    private void installHelp(DefaultsContext dc) {
        Map<String, Cmd> stringCmdMap = Commands.get(new Help(this.commands), dc);
        for (Cmd cmd : stringCmdMap.values()) {
            this.add(cmd);
        }
    }

    public static void main(String ... args) throws Exception {
        SystemEnvironment env = new SystemEnvironment();
        Consumer<Integer> onExit = System::exit;
        Main.main(env, onExit, args);
    }

    public static void main(Environment env, Consumer<Integer> onExit, String ... args) {
        try {
            Main main = new Main();
            main.main(env, args);
        }
        catch (CommandFailedException e) {
            Throwable cause = e.getCause();
            Main.handle(env, onExit, cause);
        }
        catch (Throwable throwable) {
            Main.handle(env, onExit, throwable);
        }
    }

    private static void handle(Environment env, Consumer<Integer> onExit, Throwable cause) {
        int code;
        Exit exit = cause.getClass().getAnnotation(Exit.class);
        int n = code = exit != null ? exit.value() : -1;
        if (cause instanceof HelpPrintedException) {
            onExit.accept(code);
        } else if (exit != null) {
            env.getError().println(cause.getMessage());
            onExit.accept(exit.value());
        } else {
            cause.printStackTrace(env.getError());
            onExit.accept(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void main(Environment env, String ... args) throws Exception {
        Environment old = Environment.ENVIRONMENT_THREAD_LOCAL.get();
        Environment.ENVIRONMENT_THREAD_LOCAL.set(env);
        try {
            Object result = this.exec(args);
            if (result == null) {
                return;
            }
            PrintStream out = env.getOutput();
            if (result instanceof StreamingOutput) {
                ((StreamingOutput)result).write((OutputStream)out);
            } else if (result instanceof PrintOutput) {
                ((PrintOutput)result).write(out);
            } else if (result instanceof Stream) {
                ((Stream)result).map(o -> o == null ? "" : o).map(Object::toString).forEach(out::println);
            } else if (result instanceof Iterable) {
                Iterable iterable = (Iterable)result;
                for (Object o2 : iterable) {
                    if (o2 == null) continue;
                    out.println(o2.toString());
                }
            } else if (result instanceof String) {
                String string = (String)result;
                out.print(string);
                if (!string.endsWith("\n")) {
                    out.println();
                }
            } else if (result instanceof String[][]) {
                String[][] data = (String[][])result;
                Formatting.asPrintStream(data).write(out);
            } else {
                out.println(result);
            }
        }
        finally {
            Environment.ENVIRONMENT_THREAD_LOCAL.set(old);
        }
    }

    public Object exec(String ... args) throws Exception {
        List<String> list = Main.processSystemProperties(args);
        String command = list.isEmpty() ? "help" : list.remove(0);
        args = list.toArray(new String[list.size()]);
        if (command.equals("_completion")) {
            return BashCompletion.generate(this, args);
        }
        Cmd cmd = this.commands.get(command);
        if (cmd == null) {
            PrintStream err = Environment.ENVIRONMENT_THREAD_LOCAL.get().getError();
            err.println("Unknown command: " + command);
            err.println();
            this.commands.get("help").exec(this.interceptors, new String[0]);
            throw new IllegalArgumentException();
        }
        return cmd.exec(this.interceptors, args);
    }

    public static List<String> processSystemProperties(String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        for (String arg : args) {
            if (arg.startsWith("-D")) {
                String name = arg.substring(arg.indexOf("-D") + 2, arg.indexOf(61));
                String value = arg.substring(arg.indexOf(61) + 1);
                Properties properties = Environment.ENVIRONMENT_THREAD_LOCAL.get().getProperties();
                properties.setProperty(name, value);
                continue;
            }
            list.add(arg);
        }
        return list;
    }

    @Override
    public Collection<String> complete(String buffer, int cursorPosition) {
        ArrayList<String> cmds = new ArrayList<String>();
        if (buffer == null || buffer.isEmpty()) {
            Set<String> cmd = this.commands.keySet();
            for (String s : cmd) {
                cmds.add(s + " ");
            }
        } else {
            Cmd cmd;
            if (buffer.substring(0, cursorPosition).contains(" ") && (cmd = this.getCmd(buffer)) != null) {
                return cmd.complete(buffer, cursorPosition);
            }
            String prefix = buffer.substring(0, cursorPosition);
            for (String command : this.commands.keySet()) {
                if (!command.startsWith(prefix)) continue;
                cmds.add(command + " ");
            }
        }
        Collections.sort(cmds);
        return cmds;
    }

    private Cmd getCmd(String buffer) {
        String commandName = buffer.replaceAll("^(\\w*).*?$", "$1");
        for (String cmd : this.commands.keySet()) {
            if (!cmd.equals(commandName)) continue;
            return this.commands.get(cmd);
        }
        return null;
    }
}

