/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.crest.cmds.processors;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import org.tomitribe.crest.api.Option;
import org.tomitribe.crest.cmds.processors.OptionParam;
import org.tomitribe.util.Join;

public class Item {
    private final String flag;
    private final List<String> note = new LinkedList<String>();
    private final String description;
    private final OptionParam param;

    public Item(String flag, String description, OptionParam param, List<String> notes) {
        this.flag = flag;
        this.description = description;
        this.param = param;
        this.note.addAll(notes);
    }

    Item(OptionParam p, String description) {
        String optName;
        this.description = description;
        this.param = p;
        String prefix = p.getName().length() > 1 ? "--" : "-";
        ArrayList<String> alias = new ArrayList<String>();
        Option option = (Option)p.getAnnotation(Option.class);
        for (int i = 1; i < option.value().length; ++i) {
            String aliasName = option.value()[i];
            alias.add(aliasName);
        }
        boolean hasAlias = !alias.isEmpty();
        Class type = p.getType();
        String defaultValue = p.getDefaultValue();
        String name = p.getName();
        if (Boolean.TYPE.equals(type) || Boolean.class.equals((Object)type) && defaultValue != null) {
            if ("true".equals(defaultValue)) {
                this.flag = hasAlias ? Join.join((String)", ", (Object[])new Object[]{"--no-" + name, this.getAlias(alias, false, true)}) : "--no-" + name;
            } else {
                optName = name.startsWith("-") ? name : prefix + name;
                this.flag = hasAlias ? Join.join((String)", ", (Object[])new Object[]{optName, this.getAlias(alias, true, false)}) : optName;
            }
            defaultValue = null;
        } else {
            optName = name.startsWith("-") ? name : prefix + name;
            String string = this.flag = hasAlias ? String.format("%s, %s=<%s>", optName, this.getAlias(alias, true, false), p.getDisplayType()) : String.format("%s=<%s>", optName, p.getDisplayType());
        }
        if (defaultValue != null) {
            if (p.isListable()) {
                List<String> defaultValues = p.getDefaultValues();
                if (!defaultValues.isEmpty()) {
                    this.getNote().add(String.format("default: %s", Join.join((String)", ", defaultValues)));
                }
            } else {
                this.getNote().add(String.format("default: %s", p.getDefaultValue()));
            }
        }
        if (Enum.class.isAssignableFrom(type)) {
            Class enumType = type;
            EnumSet enums = EnumSet.allOf(enumType);
            String join = Join.join((String)", ", enums);
            this.getNote().add(String.format("enum: %s", join));
        }
    }

    public OptionParam getParam() {
        return this.param;
    }

    private String getAlias(List<String> aliasList, boolean withDemiliter, boolean isBooleanValue) {
        StringBuilder sb = new StringBuilder();
        for (String alias : aliasList) {
            if (isBooleanValue) {
                sb.append(", --no-" + alias);
                continue;
            }
            if (alias.length() > 1) {
                sb.append(withDemiliter ? ", --" + alias : alias);
                continue;
            }
            sb.append(withDemiliter ? ", -" + alias : alias);
        }
        return sb.length() > 0 ? sb.toString().replaceFirst(", ", "") : "";
    }

    public String getFlag() {
        return this.flag;
    }

    public List<String> getNote() {
        return this.note;
    }

    public String getDescription() {
        return this.description;
    }
}

