/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.crest.help;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.tomitribe.crest.help.InvalidJavadocFileException;
import org.tomitribe.util.IO;
import org.tomitribe.util.Join;

public class CommandJavadoc {
    private final String clazzName;
    private final String commandName;
    private final Properties properties = new Properties();

    public CommandJavadoc(String clazzName, String commandName) {
        this.clazzName = clazzName;
        this.commandName = commandName;
    }

    public void setJavadoc(String javadoc) {
        this.getProperties().put("@javadoc", javadoc);
    }

    public String getJavadoc() {
        return this.getProperties().getProperty("@javadoc");
    }

    public void setArgNames(List<String> argNames) {
        this.getProperties().put("@arg.names", Join.join((String)", ", argNames));
    }

    public List<String> getArgNames() {
        String property = this.getProperties().getProperty("@arg.names");
        return Arrays.asList(property.split(", "));
    }

    public void setArgTypes(List<String> argTypes) {
        List normalized = argTypes.stream().map(s -> s.replaceAll("<[^<>]+>", "")).collect(Collectors.toList());
        this.getProperties().put("@arg.types", Join.join((String)", ", normalized));
    }

    public boolean matches(Class<?>[] types) {
        List list = Stream.of(types).map(this::classSignature).collect(Collectors.toList());
        String expected = this.normalize(Join.join((String)", ", list));
        String argtypes = this.normalize(this.getProperties().getProperty("@arg.types"));
        return expected.equals(argtypes);
    }

    private String normalize(String signature) {
        return signature.replace("$", ".");
    }

    public String classSignature(Class<?> aClass) {
        if (aClass.isArray()) {
            return String.format("%s[]", aClass.getComponentType().getName());
        }
        return aClass.getName();
    }

    public String getClazzName() {
        return this.clazzName;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getName() {
        return String.format("%s/%s", this.clazzName, this.commandName);
    }

    public String getResourceFileName(int i) {
        return CommandJavadoc.getResourceFileName(this.clazzName, this.commandName, i);
    }

    public static String getResourceFileName(String clazzName, String commandName, int i) {
        return String.format("META-INF/crest/%s/%s.%s.properties", clazzName, commandName, i);
    }

    public static List<CommandJavadoc> loadJavadoc(Class clazz, String commandName) {
        return CommandJavadoc.loadJavadoc(clazz.getName().replace('$', '.'), commandName);
    }

    public static List<CommandJavadoc> loadJavadoc(String clazzName, String commandName) {
        String resourceFileName;
        URL resource;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        ArrayList<CommandJavadoc> javadocs = new ArrayList<CommandJavadoc>();
        int i = 0;
        while ((resource = loader.getResource(resourceFileName = CommandJavadoc.getResourceFileName(clazzName, commandName, i))) != null) {
            CommandJavadoc javadoc = new CommandJavadoc(clazzName, commandName);
            try (InputStream in = IO.read((URL)resource);){
                javadoc.getProperties().load(in);
                javadocs.add(javadoc);
            }
            catch (IOException e) {
                throw new InvalidJavadocFileException(resourceFileName, e);
            }
            ++i;
        }
        return javadocs;
    }

    public static CommandJavadoc getCommandJavadocs(Method method, String name) {
        List<CommandJavadoc> javadocs = CommandJavadoc.loadJavadoc(method.getDeclaringClass(), name);
        return javadocs.stream().filter(commandJavadoc -> commandJavadoc.matches(method.getParameterTypes())).findFirst().orElse(null);
    }
}

