/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.crest.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.tomitribe.crest.api.PrintOutput;
import org.tomitribe.crest.table.Border;
import org.tomitribe.crest.table.Data;
import org.tomitribe.crest.table.Options;
import org.tomitribe.crest.table.Parts;
import org.tomitribe.crest.table.Table;
import org.tomitribe.crest.term.Screen;
import org.tomitribe.util.collect.ObjectMap;

public class Formatting {
    private Formatting() {
    }

    static Data asTable(Iterable<?> iterable, Options options) {
        String[] sort = Formatting.getSortArray(options);
        String[] fields = Formatting.getFieldsArray(options);
        ArrayList<List<Object>> rows = new ArrayList<List<Object>>();
        for (Object item : iterable) {
            CaseInsensitiveMap caseInsensitiveMap = Formatting.asMap(item);
            if (fields == null) {
                LinkedHashSet<String> keys = new LinkedHashSet<String>(caseInsensitiveMap.keySet());
                if (caseInsensitiveMap.isObject()) {
                    keys.remove("class");
                    fields = keys.toArray(new String[0]);
                } else {
                    fields = (String[])keys.stream().map(Parts::escape).toArray(String[]::new);
                }
            }
            ArrayList<Item> row = new ArrayList<Item>();
            for (String field : fields) {
                row.add(Formatting.resolve(caseInsensitiveMap, field));
            }
            rows.add(row);
        }
        if (sort != null && sort.length > 0) {
            rows.sort(Formatting.compareFields(fields, sort));
        }
        Data.Builder data = Data.builder();
        if (options.header()) {
            data.headings(true);
            data.row(Formatting.unescape(fields));
        }
        for (List list : rows) {
            String[] a = new String[fields.length];
            for (int i = 0; i < a.length; ++i) {
                a[i] = ((Item)list.get(i)).getString();
            }
            data.row(a);
        }
        return data.build();
    }

    private static String[] unescape(String[] fields) {
        String[] headings = new String[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            headings[i] = Parts.unescape(fields[i]);
        }
        return headings;
    }

    private static CaseInsensitiveMap asMap(Object item) {
        if (item instanceof CaseInsensitiveMap) {
            return (CaseInsensitiveMap)item;
        }
        if (item instanceof Map) {
            Map map = (Map)item;
            return new CaseInsensitiveMap(map, false);
        }
        LinkedHashMap sorted = new LinkedHashMap();
        new ObjectMap(item).entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> sorted.put(entry.getKey(), entry.getValue()));
        return new CaseInsensitiveMap(sorted, true);
    }

    private static Map<String, Object> toStringKeys(Map<?, ?> map) {
        LinkedHashMap<String, Object> dest = new LinkedHashMap<String, Object>();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            dest.put(entry.getKey().toString(), entry.getValue());
        }
        return dest;
    }

    private static String[] getSortArray(Options options) {
        String sort = options.getSort();
        String[] sortArray = sort == null || sort.length() == 0 ? null : sort.split("[ ,]+");
        return sortArray;
    }

    private static String[] getFieldsArray(Options options) {
        String fields = options.getFields();
        String[] fieldsArray = fields == null || fields.length() == 0 || "all".equals(fields) ? null : fields.split("[ ,]+");
        return fieldsArray;
    }

    public static Comparator<List<Item>> compareFields(String[] fields, String[] sort) {
        return Formatting.compareFields(Arrays.asList(fields), Arrays.asList(sort));
    }

    public static Comparator<List<Item>> compareFields(List<String> fields, List<String> sort) {
        Comparator<List> comparator = (o1, o2) -> 0;
        for (String field : sort) {
            int i = fields.indexOf(field);
            if (i < 0) continue;
            comparator = comparator.thenComparing(strings -> (Item)strings.get(i));
        }
        return comparator;
    }

    private static Item resolve(Map<?, ?> map, String field) {
        return Formatting.resolve(map, Formatting.parts(field));
    }

    private static Item resolve(Map<?, ?> map, List<String> parts) {
        if (parts.size() == 0) {
            return new Item("");
        }
        String part = parts.remove(0);
        Object object = map.get(part);
        if (object == null) {
            return new Item("");
        }
        if (parts.size() == 0) {
            return new Item(object);
        }
        return Formatting.resolve(Formatting.asMap(object), parts);
    }

    static List<String> parts(String field) {
        return Parts.from(field);
    }

    public static PrintOutput asPrintStream(String[][] strings) {
        int guess = Screen.guessWidth();
        int width = guess > 0 ? guess : 150;
        Data data = new Data(strings, true);
        Table table = new Table(data, Border.asciiCompact().build(), width);
        return table::format;
    }

    public static class Item
    implements Comparable<Item> {
        private final Comparable object;
        private final String string;

        public Item(Object value) {
            this.object = value instanceof Comparable ? (Comparable)value : null;
            this.string = value != null ? value.toString() : "";
        }

        public String getString() {
            return this.string;
        }

        @Override
        public int compareTo(Item that) {
            if (this.object != null || that.object != null) {
                if (that.object == null) {
                    return 1;
                }
                if (this.object == null) {
                    return -1;
                }
                return this.object.compareTo(that.object);
            }
            return this.string.compareTo(that.string);
        }
    }

    static class CaseInsensitiveMap
    implements Map<String, Object> {
        final Map<String, Object> map;
        private final Map<String, String> caseInsensitive;
        private final boolean object;

        public CaseInsensitiveMap(Map<?, ?> map, boolean object) {
            this.map = Formatting.toStringKeys(map);
            this.caseInsensitive = CaseInsensitiveMap.caseInsensitiveMapping(this.map);
            this.object = object;
        }

        public boolean isObject() {
            return this.object;
        }

        public Object get(String name) {
            Object value = this.map.get(name);
            if (value != null) {
                return value;
            }
            String alternateCaseName = this.caseInsensitive.get(name.toLowerCase());
            if (alternateCaseName == null) {
                return null;
            }
            return this.map.get(alternateCaseName);
        }

        @Override
        public Set<String> keySet() {
            return this.map.keySet();
        }

        private static Map<String, String> caseInsensitiveMapping(Map<String, Object> map) {
            LinkedHashMap<String, String> fieldMappings = new LinkedHashMap<String, String>();
            for (String field : map.keySet()) {
                fieldMappings.put(field.toLowerCase(), field);
            }
            return fieldMappings;
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsKey(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsValue(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object get(Object key) {
            return this.get(key.toString());
        }

        @Override
        public Object put(String key, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends String, ?> m) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<Object> values() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            throw new UnsupportedOperationException();
        }
    }
}

