/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.crest.table;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import org.tomitribe.util.Join;

public class Parts {
    private final List<String> parsed = new ArrayList<String>();
    private final Chars chars;
    private Mode mode = new ReadingToken();

    public Parts(String path) {
        this.chars = new Chars(path.toCharArray());
        try {
            while (this.chars.hasNext()) {
                this.mode.accept(this.chars.next());
            }
        }
        finally {
            this.mode.close();
        }
    }

    public static List<String> from(String path) {
        return new Parts((String)path).parsed;
    }

    public static String unescape(String path) {
        List<String> parts = Parts.from(path);
        return Join.join((String)".", parts);
    }

    public static String escape(String key) {
        return key.replace(".", "\\.");
    }

    private static class Chars {
        private final char[] chars;
        private int index;

        public Chars(char[] chars) {
            this.chars = chars;
            this.index = 0;
        }

        public char next() {
            return this.chars[this.index++];
        }

        public boolean hasNext() {
            return this.index < this.chars.length;
        }
    }

    static interface Mode
    extends Closeable {
        public void accept(char var1);

        @Override
        default public void close() {
        }
    }

    class ReadingToken
    implements Mode {
        private final StringBuilder token = new StringBuilder();

        ReadingToken() {
        }

        @Override
        public void accept(char c) {
            switch (c) {
                case '\\': {
                    Parts.this.mode = new Escape();
                    break;
                }
                case '.': {
                    Parts.this.parsed.add(this.token.toString());
                    Parts.this.mode = new ReadingToken();
                    break;
                }
                default: {
                    this.token.append(c);
                }
            }
        }

        @Override
        public void close() {
            Parts.this.parsed.add(this.token.toString());
        }

        class Escape
        implements Mode {
            Escape() {
            }

            @Override
            public void accept(char c) {
                switch (c) {
                    case '.': 
                    case '\\': {
                        ReadingToken.this.token.append(c);
                        break;
                    }
                    default: {
                        ReadingToken.this.token.append('\\');
                        ReadingToken.this.token.append(c);
                    }
                }
                Parts.this.mode = ReadingToken.this;
            }

            @Override
            public void close() {
                ReadingToken.this.token.append('\\');
                ReadingToken.this.close();
            }
        }
    }
}

