/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.crest.table;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.tomitribe.crest.table.Border;
import org.tomitribe.crest.table.Data;
import org.tomitribe.crest.table.Line;
import org.tomitribe.crest.table.Lines;
import org.tomitribe.crest.table.Resize;
import org.tomitribe.util.Join;
import org.tomitribe.util.PrintString;

class Table {
    private final Data data;
    private final Border border;

    public Table(Data data, Border border, int width) {
        int available = width - border.getWidth(data.getColumns().size()).getMax();
        this.data = Resize.resize(data, available);
        this.border = border;
    }

    public String format() {
        PrintString out = new PrintString();
        this.format((PrintStream)out);
        return out.toString();
    }

    public void format(PrintStream out) {
        String rowFormat = this.getFormat(this.border.getRow());
        String rowSeparator = this.getLine(this.border.getInner());
        Consumer<Object> printSeparator = rowSeparator != null ? o -> out.println(rowSeparator) : o -> {};
        Consumer<String[]> printRow = strings -> out.println(String.format(rowFormat, strings));
        ArrayList<Data.Row> rows = new ArrayList<Data.Row>(this.data.getRows());
        if (this.border.getFirst() != null) {
            out.println(this.getLine(this.border.getFirst()));
        }
        if (this.data.hasHeading()) {
            Stream.of(rows.remove(0)).map(Data.Row::toLines).flatMap(Stream::of).map(this::center).forEach(printRow);
            if (this.border.getHeader() != null) {
                out.println(this.getLine(this.border.getHeader()));
            }
        }
        if (rows.size() > 0) {
            Stream.of(rows.remove(0)).map(Data.Row::toLines).flatMap(Stream::of).forEach(printRow);
        }
        rows.stream().peek(printSeparator).map(Data.Row::toLines).flatMap(Stream::of).forEach(printRow);
        if (this.border.getLast() != null) {
            out.println(this.getLine(this.border.getLast()));
        }
    }

    private String[] center(String[] strings) {
        for (int column = 0; column < strings.length; ++column) {
            int width = this.data.getColumns().get(column).getWidth().getMax();
            strings[column] = Lines.center(strings[column], width);
        }
        return strings;
    }

    public String getFormat(Line line) {
        List<Data.Column> columns = this.data.getColumns();
        List formats = columns.stream().map(column -> {
            int width = column.getWidth().getMax();
            return column.isNumeric() ? "%" + width + "s" : "%-" + width + "s";
        }).collect(Collectors.toList());
        return line.getLeft() + Join.join((String)line.getInner(), formats) + line.getRight();
    }

    public String getLine(Line line) {
        if (line == null) {
            return null;
        }
        String format = this.getFormat(line);
        return String.format(format, this.rowOf(line.getMiddle()));
    }

    private String[] rowOf(String string) {
        List<Data.Column> columns = this.data.getColumns();
        String[] row = new String[columns.size()];
        for (int i = 0; i < row.length; ++i) {
            row[i] = this.columnOf(columns.get(i), string);
        }
        return row;
    }

    private String columnOf(Data.Column column, String string) {
        int size = column.getWidth().getMax();
        while (string.length() < size) {
            string = string + string;
        }
        return string.substring(0, size);
    }
}

