/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.crest.table;

import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.tomitribe.crest.api.PrintOutput;
import org.tomitribe.crest.table.Border;
import org.tomitribe.crest.table.Data;
import org.tomitribe.crest.table.Formatting;
import org.tomitribe.crest.table.Options;
import org.tomitribe.crest.table.Table;
import org.tomitribe.crest.term.Screen;

public class TableOutput
implements PrintOutput {
    private final Data data;
    private final Options options;

    public TableOutput(Iterable<?> iterable, Options options) {
        Objects.requireNonNull(iterable);
        Objects.requireNonNull(options);
        this.data = Formatting.asTable(iterable, options);
        this.options = options;
    }

    public void write(PrintStream out) throws IOException {
        int guess = Screen.guessWidth();
        int width = guess > 0 ? guess : 150;
        Border.Builder builder = this.getBuilder();
        Table table = new Table(this.data, builder.build(), width);
        table.format(out);
    }

    private Border.Builder getBuilder() {
        Border.Builder builder;
        Method method;
        String borderName = this.options.getBorder().name();
        try {
            method = Border.class.getMethod(borderName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Border not found: " + borderName);
        }
        try {
            builder = (Border.Builder)method.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Unable to access method Border." + borderName);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("Unable to call method Border." + borderName, e);
        }
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Options options = new Options();
        private Iterable<?> iterable;

        public Builder() {
            this.options.setBorder(org.tomitribe.crest.api.table.Border.asciiCompact);
            this.options.setHeader(true);
        }

        public Builder data(Stream<?> data) {
            this.iterable = data.collect(Collectors.toList());
            return this;
        }

        public Builder data(Iterable<?> data) {
            this.iterable = data;
            return this;
        }

        public Builder data(Object[] data) {
            this.iterable = Arrays.asList(data);
            return this;
        }

        public Builder sort(String sort) {
            this.options.setSort(sort);
            return this;
        }

        public Builder border(org.tomitribe.crest.api.table.Border border) {
            this.options.setBorder(border);
            return this;
        }

        public Builder header(Boolean header) {
            this.options.setHeader(header);
            return this;
        }

        public Builder fields(String fields) {
            this.options.setFields(fields);
            return this;
        }

        public TableOutput build() {
            return new TableOutput(this.iterable, this.options);
        }
    }
}

