/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.crest;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.tomitribe.crest.BashCompletion;
import org.tomitribe.crest.api.Exit;
import org.tomitribe.crest.api.PrintOutput;
import org.tomitribe.crest.api.StreamingOutput;
import org.tomitribe.crest.api.interceptor.CrestInterceptor;
import org.tomitribe.crest.cmds.Cmd;
import org.tomitribe.crest.cmds.CommandFailedException;
import org.tomitribe.crest.cmds.Completer;
import org.tomitribe.crest.cmds.HelpPrintedException;
import org.tomitribe.crest.cmds.processors.Commands;
import org.tomitribe.crest.cmds.processors.Help;
import org.tomitribe.crest.contexts.DefaultsContext;
import org.tomitribe.crest.contexts.SystemPropertiesDefaultsContext;
import org.tomitribe.crest.environments.Environment;
import org.tomitribe.crest.environments.SystemEnvironment;
import org.tomitribe.crest.interceptor.internal.InternalInterceptor;
import org.tomitribe.crest.table.Formatting;
import org.tomitribe.crest.table.TableInterceptor;

public class Main
implements Completer {
    protected final Map<String, Cmd> commands = new ConcurrentHashMap<String, Cmd>();
    protected final Map<Class<?>, InternalInterceptor> interceptors = new HashMap();
    protected final Consumer<Integer> onExit;
    protected final Environment environment;

    public Main() {
        this((DefaultsContext)new SystemPropertiesDefaultsContext(), Commands.load(), new SystemEnvironment(), System::exit);
    }

    public Main(Class<?> ... classes) {
        this(Arrays.asList(classes));
    }

    public Main(DefaultsContext defaultsContext, Class<?> ... classes) {
        this(defaultsContext, Arrays.asList(classes), new SystemEnvironment(), System::exit);
    }

    public Main(Iterable<Class<?>> classes) {
        this((DefaultsContext)new SystemPropertiesDefaultsContext(), classes, new SystemEnvironment(), System::exit);
    }

    public Main(DefaultsContext defaultsContext, Iterable<Class<?>> classes, Environment environment, Consumer<Integer> onExit) {
        this.environment = environment;
        this.onExit = onExit;
        for (Class<?> clazz : classes) {
            this.processClass(defaultsContext, clazz);
        }
        this.processClass(defaultsContext, TableInterceptor.class);
        this.installHelp(defaultsContext);
    }

    public void processClass(DefaultsContext defaultsContext, Class<?> clazz) {
        Map<String, Cmd> m = Commands.get(clazz, defaultsContext);
        if (!m.isEmpty()) {
            this.commands.putAll(m);
        } else {
            InternalInterceptor internalInterceptor = InternalInterceptor.from(clazz);
            if (this.interceptors.put(clazz, internalInterceptor) != null) {
                throw new IllegalArgumentException(clazz + " interceptor is conflicting");
            }
            for (Annotation annotation : clazz.getDeclaredAnnotations()) {
                if (!Main.isCustomInterceptorAnnotation(annotation) || this.interceptors.put(annotation.annotationType(), internalInterceptor) == null) continue;
                throw new IllegalArgumentException(clazz + " interceptor is conflicting");
            }
        }
    }

    private static boolean isCustomInterceptorAnnotation(Annotation annotation) {
        for (Annotation declaredAnnotation : annotation.annotationType().getDeclaredAnnotations()) {
            if (!(declaredAnnotation instanceof CrestInterceptor)) continue;
            return true;
        }
        return false;
    }

    public void add(Cmd cmd) {
        this.commands.put(cmd.getName(), cmd);
    }

    private void installHelp(DefaultsContext dc) {
        Map<String, Cmd> stringCmdMap = Commands.get(new Help(this.commands), dc);
        for (Cmd cmd : stringCmdMap.values()) {
            this.add(cmd);
        }
    }

    public static void main(String ... args) throws Exception {
        Main main = new Main();
        main.run(args);
    }

    public void run(String ... args) {
        try {
            this.main(this.environment, args);
        }
        catch (CommandFailedException e) {
            Throwable cause = e.getCause();
            Main.handle(this.environment, this.onExit, cause);
        }
        catch (Throwable throwable) {
            Main.handle(this.environment, this.onExit, throwable);
        }
    }

    private static void handle(Environment env, Consumer<Integer> onExit, Throwable cause) {
        int code;
        Exit exit = cause.getClass().getAnnotation(Exit.class);
        int n = code = exit != null ? exit.value() : -1;
        if (cause instanceof HelpPrintedException) {
            onExit.accept(code);
        } else if (exit != null) {
            env.getError().println(cause.getMessage());
            onExit.accept(exit.value());
        } else {
            cause.printStackTrace(env.getError());
            onExit.accept(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void main(Environment env, String ... args) throws Exception {
        Environment old = Environment.ENVIRONMENT_THREAD_LOCAL.get();
        Environment.ENVIRONMENT_THREAD_LOCAL.set(env);
        try {
            Object result = this.exec(args);
            if (result == null) {
                return;
            }
            PrintStream out = env.getOutput();
            if (result instanceof StreamingOutput) {
                ((StreamingOutput)result).write((OutputStream)out);
            } else if (result instanceof PrintOutput) {
                ((PrintOutput)result).write(out);
            } else if (result instanceof Stream) {
                ((Stream)result).map(o -> o == null ? "" : o).map(Object::toString).forEach(out::println);
            } else if (result instanceof Iterable) {
                Iterable iterable = (Iterable)result;
                for (Object o2 : iterable) {
                    if (o2 == null) continue;
                    out.println(o2.toString());
                }
            } else if (result instanceof String) {
                String string = (String)result;
                out.print(string);
                if (!string.endsWith("\n")) {
                    out.println();
                }
            } else if (result instanceof String[][]) {
                String[][] data = (String[][])result;
                Formatting.asPrintStream(data).write(out);
            } else {
                out.println(result);
            }
        }
        finally {
            Environment.ENVIRONMENT_THREAD_LOCAL.set(old);
        }
    }

    public Object exec(String ... args) throws Exception {
        List<String> list = Main.processSystemProperties(args);
        String command = list.isEmpty() ? "help" : list.remove(0);
        args = list.toArray(new String[list.size()]);
        if (command.equals("_completion")) {
            return BashCompletion.generate(this, args);
        }
        Cmd cmd = this.commands.get(command);
        if (cmd == null) {
            PrintStream err = Environment.ENVIRONMENT_THREAD_LOCAL.get().getError();
            err.println("Unknown command: " + command);
            err.println();
            this.commands.get("help").exec(this.interceptors, new String[0]);
            throw new IllegalArgumentException();
        }
        return cmd.exec(this.interceptors, args);
    }

    public static List<String> processSystemProperties(String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        for (String arg : args) {
            if (arg.startsWith("-D")) {
                String name = arg.substring(arg.indexOf("-D") + 2, arg.indexOf(61));
                String value = arg.substring(arg.indexOf(61) + 1);
                Properties properties = Environment.ENVIRONMENT_THREAD_LOCAL.get().getProperties();
                properties.setProperty(name, value);
                continue;
            }
            list.add(arg);
        }
        return list;
    }

    @Override
    public Collection<String> complete(String buffer, int cursorPosition) {
        ArrayList<String> cmds = new ArrayList<String>();
        if (buffer == null || buffer.isEmpty()) {
            Set<String> cmd = this.commands.keySet();
            for (String s : cmd) {
                cmds.add(s + " ");
            }
        } else {
            Cmd cmd;
            if (buffer.substring(0, cursorPosition).contains(" ") && (cmd = this.getCmd(buffer)) != null) {
                return cmd.complete(buffer, cursorPosition);
            }
            String prefix = buffer.substring(0, cursorPosition);
            for (String command : this.commands.keySet()) {
                if (!command.startsWith(prefix)) continue;
                cmds.add(command + " ");
            }
        }
        Collections.sort(cmds);
        return cmds;
    }

    private Cmd getCmd(String buffer) {
        String commandName = buffer.replaceAll("^(\\w*).*?$", "$1");
        for (String cmd : this.commands.keySet()) {
            if (!cmd.equals(commandName)) continue;
            return this.commands.get(cmd);
        }
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder systemDefaults() {
        return Main.builder().properties(System.getProperties()).env(System.getenv()).out(System.out).err(System.err).in(System.in).exit(System::exit);
    }

    public static class Builder {
        private Map<String, String> env = new LinkedHashMap<String, String>();
        private PrintStream out;
        private PrintStream err;
        private InputStream in;
        private List<Class<?>> commands = new ArrayList();
        private Consumer<Integer> exit;
        private Properties properties;

        public Builder env(String name, String value) {
            this.env.put(name, value);
            return this;
        }

        public Builder env(Map<String, String> env) {
            this.env = env;
            return this;
        }

        public Builder property(String name, String value) {
            this.properties.put(name, value);
            return this;
        }

        public Builder properties(Properties properties) {
            this.properties = properties;
            return this;
        }

        public Builder out(PrintStream out) {
            this.out = out;
            return this;
        }

        public Builder err(PrintStream err) {
            this.err = err;
            return this;
        }

        public Builder in(InputStream in) {
            this.in = in;
            return this;
        }

        public Builder command(Class<?> commandClass) {
            this.commands.add(commandClass);
            return this;
        }

        public Builder exit(Consumer<Integer> consumer) {
            this.exit = consumer;
            return this;
        }

        public Builder noexit() {
            this.exit = integer -> {};
            return this;
        }

        public Main build() {
            try {
                BuiltEnvironment environment = new BuiltEnvironment();
                Iterable<Class<?>> commands = this.commands.size() == 0 ? Commands.load() : this.commands;
                return new Main((DefaultsContext)new SystemPropertiesDefaultsContext(), commands, environment, this.exit);
            }
            catch (Exception e) {
                throw new MainBuildException(e);
            }
        }

        @Exit(value=1)
        public static class MainBuildException
        extends RuntimeException {
            public MainBuildException(Exception e) {
                super(String.format("Unable to build Main. " + e.getMessage(), new Object[0]));
            }
        }

        private class BuiltEnvironment
        implements Environment {
            private BuiltEnvironment() {
            }

            @Override
            public PrintStream getOutput() {
                return Builder.this.out;
            }

            @Override
            public PrintStream getError() {
                return Builder.this.err;
            }

            @Override
            public InputStream getInput() {
                return Builder.this.in;
            }

            @Override
            public Properties getProperties() {
                return Builder.this.properties;
            }

            @Override
            public <T> T findService(Class<T> type) {
                return null;
            }
        }
    }
}

