/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.crest.help;

import java.util.function.Function;
import org.tomitribe.crest.help.Wrap;
import org.tomitribe.util.Join;

public class Justify {
    private final int width;
    private Function<String, String> padding;

    public Justify(int width) {
        this.width = width;
        this.padding = this::fromLeft;
    }

    public static String wrapAndJustify(String text, int width) {
        Justify justify = new Justify(width);
        return justify.wrapAndJustify(text);
    }

    private String wrapAndJustify(String text) {
        String wrapped = Wrap.wrap(text, this.width, null, true);
        String[] lines = wrapped.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            String padded = this.padding.apply(lines[i]);
            if (padded.length() != this.width) continue;
            lines[i] = padded;
        }
        return Join.join((String)"\n", (Object[])lines);
    }

    private String fromLeft(String line) {
        StringBuilder b = new StringBuilder(line);
        int needed = this.width - b.length();
        needed = this.padSentences(b, needed);
        for (int i = 0; needed > 0 && i < b.length(); ++i) {
            char c = b.charAt(i);
            if (c != ' ') continue;
            b.insert(i, ' ');
            ++i;
            --needed;
        }
        this.padding = this::fromRight;
        return b.toString();
    }

    private String fromRight(String line) {
        StringBuilder b = new StringBuilder(line);
        int needed = this.width - b.length();
        needed = this.padSentences(b, needed);
        for (int i = b.length() - 1; needed > 0 && i > 0; --i) {
            char c = b.charAt(i);
            if (c != ' ') continue;
            b.insert(i, ' ');
            --needed;
        }
        this.padding = this::fromLeft;
        return b.toString();
    }

    private int padSentences(StringBuilder b, int needed) {
        if (needed == 0) {
            return needed;
        }
        for (int i = 0; needed > 0 && i < b.length(); ++i) {
            char c = b.charAt(i);
            if (c != '.' || b.length() <= i + 1 || b.charAt(i + 1) != ' ') continue;
            b.insert(i + 1, ' ');
            i += 2;
            --needed;
        }
        return needed;
    }
}

