/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.crest.lang;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public abstract class Substitutor {
    private static final char ESCAPE = '$';
    private static final char[] PREFIX = "${".toCharArray();
    private static final char[] SUFFIX = "}".toCharArray();
    private static final char[] VALUE_DELIMITER = ":-".toCharArray();

    public String replace(String source) {
        if (source == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder(source);
        if (this.substitute(builder, 0, source.length(), null) <= 0) {
            return source;
        }
        return this.replace(builder.toString());
    }

    private int substitute(StringBuilder buf, int offset, int length, List<String> priorVariables) {
        boolean top = priorVariables == null;
        boolean altered = false;
        int lengthChange = 0;
        char[] chars = buf.toString().toCharArray();
        int bufEnd = offset + length;
        int pos = offset;
        block0: while (pos < bufEnd) {
            int startMatchLen = this.isMatch(PREFIX, chars, pos, bufEnd);
            if (startMatchLen == 0) {
                ++pos;
                continue;
            }
            if (pos > offset && chars[pos - 1] == '$') {
                buf.deleteCharAt(pos - 1);
                chars = buf.toString().toCharArray();
                --lengthChange;
                altered = true;
                --bufEnd;
                continue;
            }
            int startPos = pos;
            pos += startMatchLen;
            while (pos < bufEnd) {
                int endMatchLen = this.isMatch(SUFFIX, chars, pos, bufEnd);
                if (endMatchLen == 0) {
                    ++pos;
                    continue;
                }
                String varNameExpr = new String(chars, startPos + startMatchLen, pos - startPos - startMatchLen);
                int endPos = pos += endMatchLen;
                String varName = varNameExpr;
                String varDefaultValue = null;
                char[] varNameExprChars = varNameExpr.toCharArray();
                for (int i = 0; i < varNameExprChars.length && this.isMatch(PREFIX, varNameExprChars, i, varNameExprChars.length) == 0; ++i) {
                    int match = this.isMatch(VALUE_DELIMITER, varNameExprChars, i, varNameExprChars.length);
                    if (match == 0) continue;
                    varName = varNameExpr.substring(0, i);
                    varDefaultValue = varNameExpr.substring(i + match);
                    break;
                }
                if (priorVariables == null) {
                    priorVariables = new ArrayList<String>();
                    priorVariables.add(new String(chars, offset, length));
                }
                this.checkCyclicSubstitution(varName, priorVariables);
                priorVariables.add(varName);
                String varValue = this.getOrDefault(varName, varDefaultValue);
                if (varValue != null) {
                    int varLen = varValue.length();
                    buf.replace(startPos, endPos, varValue);
                    altered = true;
                    int change = this.substitute(buf, startPos, varLen, priorVariables);
                    change = change + varLen - (endPos - startPos);
                    pos += change;
                    bufEnd += change;
                    lengthChange += change;
                    chars = buf.toString().toCharArray();
                }
                priorVariables.remove(priorVariables.size() - 1);
                continue block0;
            }
        }
        if (top) {
            return altered ? 1 : 0;
        }
        return lengthChange;
    }

    protected abstract String getOrDefault(String var1, String var2);

    private int isMatch(char[] chars, char[] buffer, int pos, int bufferEnd) {
        int len = chars.length;
        if (pos + len > bufferEnd) {
            return 0;
        }
        int i = 0;
        while (i < chars.length) {
            if (chars[i] != buffer[pos]) {
                return 0;
            }
            ++i;
            ++pos;
        }
        return len;
    }

    private void checkCyclicSubstitution(String varName, List<String> priorVariables) {
        if (!priorVariables.contains(varName)) {
            return;
        }
        StringBuilder buf = new StringBuilder(256);
        buf.append("Infinite loop in property interpolation of ");
        buf.append(priorVariables.remove(0));
        buf.append(": ");
        this.appendWithSeparators(buf, priorVariables);
        throw new IllegalStateException(buf.toString());
    }

    private void appendWithSeparators(StringBuilder builder, Collection<String> iterable) {
        if (iterable != null && !iterable.isEmpty()) {
            Iterator<String> it = iterable.iterator();
            while (it.hasNext()) {
                builder.append((Object)it.next());
                if (!it.hasNext()) continue;
                builder.append("->");
            }
        }
    }
}

