/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.crest.table;

public class Line {
    private final String left;
    private final String right;
    private final String inner;
    private final String middle;
    private final boolean padded;

    public Line(String left, String right, String inner, String middle, boolean padded) {
        this.left = left;
        this.right = right;
        this.inner = inner;
        this.middle = middle;
        this.padded = padded;
    }

    public String getLeft() {
        return this.left;
    }

    public String getRight() {
        return this.right;
    }

    public String getMiddle() {
        return this.middle;
    }

    public String getInner() {
        return this.inner;
    }

    public boolean isPadded() {
        return this.padded;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String left;
        private String right;
        private String inner;
        private String middle;
        private boolean padded = true;

        private Builder() {
        }

        public Builder all(String string) {
            this.left = string;
            this.right = string;
            this.middle = string;
            this.inner = string;
            return this;
        }

        public Builder left(String left) {
            this.left = left;
            return this;
        }

        public Builder right(String right) {
            this.right = right;
            return this;
        }

        public Builder inner(String inner) {
            this.inner = inner;
            return this;
        }

        public Builder middle(String middle) {
            this.middle = middle;
            return this;
        }

        public Builder padded(boolean padded) {
            this.padded = padded;
            return this;
        }

        public Line build() {
            return new Line(this.left, this.right, this.inner, this.middle, this.padded);
        }
    }
}

