/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.crest.table;

import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.tomitribe.crest.table.Data;
import org.tomitribe.crest.table.Width;

public class Tables {
    private Tables() {
    }

    static int getMaxWidth(String[][] data) {
        int max = 0;
        for (String[] row : data) {
            if (row == null) continue;
            max = Math.max(max, row.length);
        }
        return max;
    }

    static Data.Cell[][] createCells(Data table, String[][] data) {
        int width = Tables.getMaxWidth(data);
        Data.Cell[][] cells = new Data.Cell[data.length][width];
        for (int row = 0; row < data.length; ++row) {
            int column;
            String[] strings = data[row];
            if (strings != null) {
                for (column = 0; column < strings.length; ++column) {
                    String string = strings[column];
                    Data.Cell[] cellArray = cells[row];
                    Data data2 = table;
                    data2.getClass();
                    cellArray[column] = data2.new Data.Cell(row, column, string);
                }
            }
            for (column = 0; column < cells[row].length; ++column) {
                if (cells[row][column] != null) continue;
                Data.Cell[] cellArray = cells[row];
                Data data3 = table;
                data3.getClass();
                cellArray[column] = data3.new Data.Cell(row, column, "");
            }
        }
        return cells;
    }

    static Data.Row[] createRows(Data table, Data.Cell[][] cells) {
        Data.Row[] rows = new Data.Row[cells.length];
        for (int i = 0; i < rows.length; ++i) {
            rows[i] = Tables.createRow(table, cells, i);
        }
        return rows;
    }

    private static Data.Row createRow(Data table, Data.Cell[][] cells, int row) {
        int height = Tables.cellsInRow(cells, row).mapToInt(Data.Cell::getHeight).reduce(Math::max).orElse(0);
        Width width = Tables.cellsInRow(cells, row).map(Data.Cell::getWidth).reduce(Width::add).orElse(Width.ZERO);
        Data data = table;
        data.getClass();
        return data.new Data.Row(row, width, height);
    }

    static Data.Column[] createColumns(Data table, Data.Cell[][] cells) {
        Data.Column[] columns = new Data.Column[cells[0].length];
        for (int i = 0; i < columns.length; ++i) {
            columns[i] = Tables.createColumn(table, cells, i);
        }
        return columns;
    }

    private static Data.Column createColumn(Data table, Data.Cell[][] cells, int column) {
        Predicate<Data.Cell> isHeading = cell -> table.hasHeading() && cell.getRow() == 0;
        Predicate<String> isNumeric = Pattern.compile("^-?[$\u00a3\u20ac\u00a5\u20b4]?[0-9]+[0-9,.]*%?$|^$").asPredicate();
        Boolean numeric = Tables.cellsInColumn(cells, column).filter(isHeading.negate()).map(Data.Cell::getData).map(isNumeric::test).reduce((aBoolean, aBoolean2) -> aBoolean != false && aBoolean2 != false).orElse(false);
        Width width = Tables.cellsInColumn(cells, column).map(Data.Cell::getWidth).reduce(Width::adjust).orElse(new Width(0, 0));
        Data data = table;
        data.getClass();
        return data.new Data.Column(column, width, numeric);
    }

    public static Stream<Data.Cell> cellsInRow(Data.Cell[][] cells, int row) {
        return Stream.of(cells[row]);
    }

    public static Stream<Data.Cell> cellsInColumn(Data.Cell[][] cells, int column) {
        return Stream.of(cells).map(row -> row[column]);
    }
}

