/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.crest.cmds.processors;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.ServiceLoader;
import org.tomitribe.crest.api.Command;
import org.tomitribe.crest.cmds.Cmd;
import org.tomitribe.crest.cmds.CmdGroup;
import org.tomitribe.crest.cmds.CmdMethod;
import org.tomitribe.crest.cmds.OverloadedCmdMethod;
import org.tomitribe.crest.cmds.targets.SimpleBean;
import org.tomitribe.crest.cmds.targets.Target;
import org.tomitribe.crest.contexts.DefaultsContext;
import org.tomitribe.crest.contexts.SystemPropertiesDefaultsContext;
import org.tomitribe.util.Strings;
import org.tomitribe.util.collect.FilteredIterable;
import org.tomitribe.util.collect.FilteredIterator;
import org.tomitribe.util.reflect.Reflection;

public class Commands {
    private Commands() {
    }

    public static Iterable<Method> commands(Class<?> clazz) {
        return new FilteredIterable(Reflection.methods(clazz), (FilteredIterator.Filter)new FilteredIterator.Filter<Method>(){

            public boolean accept(Method method) {
                return method.isAnnotationPresent(Command.class);
            }
        });
    }

    public static Map<String, Cmd> get(Object bean) {
        return Commands.get(bean.getClass(), new SimpleBean(bean), new SystemPropertiesDefaultsContext());
    }

    public static Map<String, Cmd> get(Object bean, DefaultsContext dc) {
        return Commands.get(bean.getClass(), new SimpleBean(bean), dc);
    }

    public static Map<String, Cmd> get(Class<?> clazz) {
        return Commands.get(clazz, new SimpleBean(null), new SystemPropertiesDefaultsContext());
    }

    public static Map<String, Cmd> get(Class<?> clazz, DefaultsContext dc) {
        return Commands.get(clazz, new SimpleBean(null), dc);
    }

    public static Map<String, Cmd> get(Class<?> clazz, Target target, DefaultsContext dc) {
        if (target == null) {
            throw new IllegalArgumentException("Target cannot be null");
        }
        HashMap<String, Cmd> map = new HashMap<String, Cmd>();
        for (Method method : Commands.commands(clazz)) {
            OverloadedCmdMethod overloaded;
            CmdMethod cmd = new CmdMethod(method, target, dc);
            Cmd existing = (Cmd)map.get(cmd.getName());
            if (existing == null) {
                map.put(cmd.getName(), cmd);
                continue;
            }
            if (existing instanceof OverloadedCmdMethod) {
                overloaded = (OverloadedCmdMethod)existing;
                overloaded.add(cmd);
                continue;
            }
            overloaded = new OverloadedCmdMethod(cmd.getName());
            overloaded.add((CmdMethod)existing);
            overloaded.add(cmd);
            map.put(overloaded.getName(), overloaded);
        }
        if (clazz.isAnnotationPresent(Command.class)) {
            CmdGroup cmdGroup = new CmdGroup(clazz, map);
            HashMap<String, Cmd> group = new HashMap<String, Cmd>();
            group.put(cmdGroup.getName(), cmdGroup);
            return group;
        }
        return map;
    }

    public static String name(Method method) {
        Command command = method.getAnnotation(Command.class);
        if (command == null) {
            return method.getName();
        }
        return Commands.value(command.value(), method.getName());
    }

    public static String name(Class<?> clazz) {
        Command command = clazz.getAnnotation(Command.class);
        String defaultName = Strings.lcfirst((String)clazz.getSimpleName());
        if (command == null) {
            return defaultName;
        }
        return Commands.value(command.value(), defaultName);
    }

    public static String value(String value, String defaultValue) {
        return value == null || value.length() == 0 ? defaultValue : value;
    }

    public static Iterable<Class<?>> load() {
        Iterator<Loader> all = ServiceLoader.load(Loader.class).iterator();
        LinkedHashSet classes = new LinkedHashSet();
        while (all.hasNext()) {
            Iterable c = all.next();
            for (Class clazz : c) {
                classes.add(clazz);
            }
        }
        return classes;
    }

    public static interface Loader
    extends Iterable<Class<?>> {
    }
}

