/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.crest.cmds.processors;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TreeSet;
import org.tomitribe.crest.api.Command;
import org.tomitribe.crest.api.Option;
import org.tomitribe.crest.cmds.Cmd;
import org.tomitribe.crest.cmds.CmdGroup;
import org.tomitribe.crest.cmds.processors.OptionParam;
import org.tomitribe.util.Join;
import org.tomitribe.util.PrintString;
import org.tomitribe.util.reflect.Classes;

public class Help {
    private final Map<String, Cmd> commands;

    public Help(Map<String, Cmd> commands1) {
        this.commands = commands1;
    }

    public static void optionHelp(Class<?> clazz, String commandName, Collection<OptionParam> optionParams, PrintStream out) {
        if (optionParams.size() == 0) {
            return;
        }
        ResourceBundle general = Help.getResourceBundle(clazz);
        ArrayList<Item> items = new ArrayList<Item>(optionParams.size());
        int width = 20;
        for (OptionParam optionParam : optionParams) {
            String description = Help.getDescription(general, commandName, optionParam.getName());
            Item item = new Item(optionParam, description);
            items.add(item);
            width = Math.max(width, item.flag.length());
        }
        String format = "  %-" + width + "s     %s%n";
        out.println("Options: ");
        for (Item item : items) {
            ArrayList<String> lines = new ArrayList<String>();
            if (item.description != null) {
                lines.add(item.description);
            }
            lines.addAll(item.note);
            if (lines.size() == 0) {
                lines.add("");
            }
            out.printf(format, item.flag, lines.remove(0));
            for (String line : lines) {
                out.printf(format, "", String.format("(%s)", line));
            }
        }
    }

    public static ResourceBundle getResourceBundle(Class<?> clazz) {
        try {
            return ResourceBundle.getBundle(Classes.packageName(clazz) + ".OptionDescriptions");
        }
        catch (MissingResourceException ok) {
            return null;
        }
    }

    public static String getDescription(ResourceBundle general, String commandName, String name) {
        if (general == null) {
            return null;
        }
        try {
            return general.getString(commandName + "." + name);
        }
        catch (MissingResourceException e) {
            try {
                return general.getString(name);
            }
            catch (MissingResourceException e1) {
                return null;
            }
        }
    }

    @Command
    public String help() {
        PrintString string = new PrintString();
        string.println("Commands: ");
        string.printf("   %-20s", new Object[]{""});
        string.println();
        TreeSet<String> strings = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                assert (null != s1);
                assert (null != s2);
                return s1.compareTo(s2);
            }
        });
        strings.addAll(this.commands.keySet());
        for (String command : strings) {
            string.printf("   %-20s%n", new Object[]{command});
        }
        return string.toString();
    }

    @Command
    public String help(String name) {
        Cmd cmd = this.commands.get(name);
        if (cmd == null) {
            return String.format("No such command: %s%n", name);
        }
        PrintString out = new PrintString();
        cmd.help((PrintStream)out);
        return out.toString();
    }

    @Command
    public String help(String name, String subCommand) {
        Cmd cmd = this.commands.get(name);
        if (cmd == null) {
            return String.format("No such command: %s%n", name);
        }
        PrintString out = new PrintString();
        if (cmd instanceof CmdGroup) {
            CmdGroup cmdGroup = (CmdGroup)cmd;
            cmdGroup.help(subCommand, (PrintStream)out);
        } else {
            cmd.help((PrintStream)out);
        }
        return out.toString();
    }

    private static class Item {
        private final String flag;
        private final List<String> note = new LinkedList<String>();
        private final String description;

        private Item(OptionParam p, String description) {
            String optName;
            this.description = description;
            String prefix = p.getName().length() > 1 ? "--" : "-";
            ArrayList<String> alias = new ArrayList<String>();
            Option option = (Option)p.getAnnotation(Option.class);
            for (int i = 1; i < option.value().length; ++i) {
                String aliasName = option.value()[i];
                alias.add(aliasName);
            }
            boolean hasAlias = alias.size() > 0;
            Class type = p.getType();
            String defaultValue = p.getDefaultValue();
            String name = p.getName();
            if (Boolean.TYPE.equals(type) || Boolean.class.equals((Object)type) && defaultValue != null) {
                if ("true".equals(defaultValue)) {
                    this.flag = hasAlias ? Join.join((String)", ", (Object[])new Object[]{"--no-" + name, this.getAlias(alias, false, true)}) : "--no-" + name;
                } else {
                    optName = name.startsWith("-") ? name : prefix + name;
                    this.flag = hasAlias ? Join.join((String)", ", (Object[])new Object[]{optName, this.getAlias(alias, true, false)}) : optName;
                }
                defaultValue = null;
            } else {
                optName = name.startsWith("-") ? name : prefix + name;
                String string = this.flag = hasAlias ? String.format("%s, %s=<%s>", optName, this.getAlias(alias, true, false), p.getDisplayType()) : String.format("%s=<%s>", optName, p.getDisplayType());
            }
            if (defaultValue != null) {
                if (p.isListable()) {
                    List<String> defaultValues = p.getDefaultValues();
                    if (defaultValues.size() > 0) {
                        this.note.add(String.format("default: %s", Join.join((String)", ", defaultValues)));
                    }
                } else {
                    this.note.add(String.format("default: %s", p.getDefaultValue()));
                }
            }
            if (Enum.class.isAssignableFrom(type)) {
                Class enumType = type;
                EnumSet enums = EnumSet.allOf(enumType);
                String join = Join.join((String)", ", enums);
                this.note.add(String.format("enum: %s", join));
            }
        }

        private String getAlias(List<String> aliasList, boolean withDemiliter, boolean isBooleanValue) {
            StringBuilder sb = new StringBuilder();
            for (String alias : aliasList) {
                if (isBooleanValue) {
                    sb.append(", --no-" + alias);
                    continue;
                }
                if (alias.length() > 1) {
                    sb.append(withDemiliter ? ", --" + alias : alias);
                    continue;
                }
                sb.append(withDemiliter ? ", -" + alias : alias);
            }
            return sb.length() > 0 ? sb.toString().replaceFirst(", ", "") : "";
        }
    }
}

