/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.crest.cmds.targets;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.tomitribe.crest.cmds.targets.Target;

public class SimpleBean
implements Target {
    private final Object bean;

    public SimpleBean(Object bean) {
        this.bean = bean;
    }

    @Override
    public Object invoke(Method method, Object ... args) throws InvocationTargetException, IllegalAccessException {
        Object bean = this.getBean(method);
        return method.invoke(bean, args);
    }

    private Object getBean(Method method) {
        if (this.bean != null) {
            return this.bean;
        }
        if (Modifier.isStatic(method.getModifiers())) {
            return this.bean;
        }
        try {
            Class<?> declaringClass = method.getDeclaringClass();
            Constructor<?> constructor = declaringClass.getConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e.getCause());
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }
}

