/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.crest.val;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import org.apache.bval.jsr303.ApacheValidationProvider;
import org.apache.bval.jsr303.ApacheValidatorConfiguration;
import org.apache.bval.jsr303.extensions.MethodValidator;

public class BeanValidation {
    private BeanValidation() {
    }

    public static boolean isActive() {
        try {
            Class.forName("javax.validation.Validator", false, BeanValidation.class.getClassLoader());
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static void validateParameters(Class clazz, Method method, Object[] parameters) throws Exception {
        if (!BeanValidation.isActive()) {
            return;
        }
        Helper.validateParameters(clazz, method, parameters);
    }

    public static void validateParameters(Class clazz, Constructor constructor, Object[] parameters) throws Exception {
        if (!BeanValidation.isActive()) {
            return;
        }
        Helper.validateParameters(clazz, constructor, parameters);
    }

    public static Iterable<? extends String> messages(Exception e) {
        if (!ConstraintViolationException.class.isInstance(e)) {
            return Arrays.asList(e.getMessage());
        }
        LinkedList<String> msg = new LinkedList<String>();
        ConstraintViolationException cve = (ConstraintViolationException)e;
        for (ConstraintViolation violation : cve.getConstraintViolations()) {
            msg.add(violation.getMessage());
        }
        return msg;
    }

    private static class Helper {
        private Helper() {
        }

        public static void validateParameters(Class clazz, Method method, Object[] parameters) {
            MethodValidator validatorObject = Helper.getValidatorObject();
            Set violations = validatorObject.validateParameters(clazz, method, parameters, new Class[0]);
            if (violations.size() > 0) {
                throw new ConstraintViolationException(violations);
            }
        }

        public static void validateParameters(Class clazz, Constructor constructor, Object[] parameters) {
            MethodValidator validatorObject = Helper.getValidatorObject();
            Set violations = validatorObject.validateParameters(clazz, constructor, parameters, new Class[0]);
            if (violations.size() > 0) {
                throw new ConstraintViolationException(violations);
            }
        }

        private static MethodValidator getValidatorObject() {
            ApacheValidatorConfiguration configure = (ApacheValidatorConfiguration)Validation.byProvider(ApacheValidationProvider.class).configure();
            ValidatorFactory validatorFactory = configure.buildValidatorFactory();
            return (MethodValidator)validatorFactory.getValidator().unwrap(MethodValidator.class);
        }
    }
}

