/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.crest.cmds;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.tomitribe.crest.cmds.Cmd;
import org.tomitribe.crest.cmds.processors.Commands;
import org.tomitribe.crest.cmds.utils.CommandLine;
import org.tomitribe.crest.environments.Environment;

public class CmdGroup
implements Cmd {
    final String name;
    final Map<String, Cmd> commands = new TreeMap<String, Cmd>();

    public CmdGroup(Class<?> owner, Map<String, Cmd> commands) {
        this.name = Commands.name(owner);
        this.commands.putAll(commands);
    }

    @Override
    public String getUsage() {
        return this.name + " [subcommand] [options]";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object exec(String ... rawArgs) {
        if (rawArgs.length == 0) {
            throw this.report(new IllegalArgumentException("Missing sub-command"));
        }
        String name = rawArgs[0];
        Cmd cmd = this.commands.get(name);
        if (cmd == null) {
            throw this.report(new IllegalArgumentException("No such sub-command: " + name));
        }
        String[] newArgs = new String[rawArgs.length - 1];
        System.arraycopy(rawArgs, 1, newArgs, 0, newArgs.length);
        return cmd.exec(newArgs);
    }

    private <E extends RuntimeException> E report(E e) {
        PrintStream err = Environment.ENVIRONMENT_THREAD_LOCAL.get().getError();
        err.println(e.getMessage());
        this.help(err);
        return e;
    }

    @Override
    public void help(PrintStream out) {
        out.print("Usage: ");
        out.println(this.getUsage());
        out.println();
        out.println("Sub commands: ");
        out.printf("   %-20s", "");
        out.println();
        TreeSet<String> strings = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                assert (null != s1);
                assert (null != s2);
                return s1.compareTo(s2);
            }
        });
        strings.addAll(this.commands.keySet());
        for (String command : strings) {
            out.printf("   %-20s%n", command);
        }
    }

    public void help(String subCommand, PrintStream out) {
        Cmd subCmd = this.commands.get(subCommand);
        if (subCmd == null) {
            this.help(out);
        } else {
            subCmd.help(out);
        }
    }

    @Override
    public Collection<String> complete(String buffer, int cursorPosition) {
        ArrayList<String> results = new ArrayList<String>();
        try {
            String commandLine = buffer.substring(0, cursorPosition);
            String[] args = CommandLine.translateCommandline(commandLine);
            if (args.length >= 1 && args[0].equals(this.getName())) {
                if (args.length > 2 || args.length == 2 && commandLine.endsWith(" ")) {
                    Cmd cmd = this.commands.get(args[1]);
                    if (cmd != null) {
                        String subcommand = buffer.replaceAll(this.getName() + "\\s+(.*)$", "$1");
                        int diff = buffer.length() - subcommand.length();
                        return cmd.complete(subcommand, cursorPosition - diff);
                    }
                    return results;
                }
                String prefix = args.length == 1 && commandLine.endsWith(" ") ? "" : args[1];
                for (String commandName : this.commands.keySet()) {
                    if (!commandName.startsWith(prefix)) continue;
                    results.add(commandName + " ");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return results;
    }
}

