/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.crest.cmds.processors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.tomitribe.crest.api.Default;
import org.tomitribe.crest.cmds.processors.Param;
import org.tomitribe.crest.cmds.processors.types.PrimitiveTypes;
import org.tomitribe.util.Join;
import org.tomitribe.util.reflect.Parameter;

public class OptionParam
extends Param {
    public static final String LIST_SEPARATOR = "\u0000";
    public static final String LIST_TYPE = "\uffff\uffff";
    private final String name;
    private final String defaultValue;

    public OptionParam(Parameter parameter, String name, String defaultVal) {
        super(parameter);
        this.name = name;
        this.defaultValue = defaultVal == null ? this.initDefault() : defaultVal;
    }

    public static List<String> getSeparatedValues(String value) {
        if (value == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> split = new ArrayList<String>(Arrays.asList(value.split("\uffff\uffff|\u0000")));
        if (split.size() > 0) {
            split.remove(0);
        }
        return split;
    }

    private String initDefault() {
        Default def = (Default)this.getAnnotation(Default.class);
        if (def != null) {
            if (this.isListable()) {
                return LIST_TYPE + this.normalize(def);
            }
            return def.value();
        }
        if (this.isListable()) {
            return LIST_TYPE;
        }
        if (this.getType().isPrimitive()) {
            Class type = this.getType();
            return PrimitiveTypes.valueOf(type.toString().toUpperCase()).getDefaultValue();
        }
        return null;
    }

    public String normalize(Default def) {
        String value = def.value();
        if (value.contains(LIST_SEPARATOR)) {
            return value;
        }
        if (value.contains("\t")) {
            Object[] split = value.split("\t");
            return Join.join((String)LIST_SEPARATOR, (Object[])split);
        }
        if (value.contains(",")) {
            Object[] split = value.split(",");
            return Join.join((String)LIST_SEPARATOR, (Object[])split);
        }
        return value;
    }

    public String getName() {
        return this.name;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public List<String> getDefaultValues() {
        return OptionParam.getSeparatedValues(this.defaultValue);
    }

    public String toString() {
        return "Option{name='" + this.name + '\'' + ", default='" + this.defaultValue + '\'' + '}';
    }
}

