/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.crest;

import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.tomitribe.crest.api.Exit;
import org.tomitribe.crest.api.StreamingOutput;
import org.tomitribe.crest.api.interceptor.CrestInterceptor;
import org.tomitribe.crest.cmds.Cmd;
import org.tomitribe.crest.cmds.CommandFailedException;
import org.tomitribe.crest.cmds.Completer;
import org.tomitribe.crest.cmds.processors.Commands;
import org.tomitribe.crest.cmds.processors.Help;
import org.tomitribe.crest.cmds.targets.SimpleBean;
import org.tomitribe.crest.contexts.DefaultsContext;
import org.tomitribe.crest.contexts.SystemPropertiesDefaultsContext;
import org.tomitribe.crest.environments.Environment;
import org.tomitribe.crest.environments.SystemEnvironment;
import org.tomitribe.crest.interceptor.internal.InternalInterceptor;

public class Main
implements Completer {
    protected final Map<String, Cmd> commands = new ConcurrentHashMap<String, Cmd>();
    protected final Map<Class<?>, InternalInterceptor> interceptors = new HashMap();

    public Main() {
        this((DefaultsContext)new SystemPropertiesDefaultsContext(), Commands.load());
    }

    public Main(Class<?> ... classes) {
        this(Arrays.asList(classes));
    }

    public Main(DefaultsContext defaultsContext, Class<?> ... classes) {
        this(defaultsContext, Arrays.asList(classes));
    }

    public Main(DefaultsContext defaultsContext, Iterable<Class<?>> classes) {
        for (Class clazz : classes) {
            Map<String, Cmd> m = Commands.get(clazz, defaultsContext);
            if (!m.isEmpty()) {
                this.commands.putAll(m);
                continue;
            }
            for (Method method : clazz.getMethods()) {
                Class key;
                CrestInterceptor interceptor;
                if (Object.class == method.getDeclaringClass() || (interceptor = method.getAnnotation(CrestInterceptor.class)) == null) continue;
                Class clazz2 = key = interceptor.value() == Object.class ? clazz : interceptor.value();
                if (this.interceptors.put(key, new InternalInterceptor(new SimpleBean(null), method)) == null) continue;
                throw new IllegalArgumentException(key + " interceptor is conflicting");
            }
        }
        this.installHelp(defaultsContext);
    }

    public Main(Iterable<Class<?>> classes) {
        this((DefaultsContext)new SystemPropertiesDefaultsContext(), classes);
    }

    public void add(Cmd cmd) {
        this.commands.put(cmd.getName(), cmd);
    }

    public void remove(Cmd cmd) {
        this.commands.remove(cmd.getName());
    }

    private void installHelp(DefaultsContext dc) {
        Map<String, Cmd> stringCmdMap = Commands.get(new Help(this.commands), dc);
        for (Cmd cmd : stringCmdMap.values()) {
            this.add(cmd);
        }
    }

    public static void main(String ... args) throws Exception {
        try {
            SystemEnvironment env = new SystemEnvironment();
            Main main = new Main();
            main.main(env, args);
        }
        catch (CommandFailedException e) {
            Throwable cause = e.getCause();
            Exit exit = cause.getClass().getAnnotation(Exit.class);
            if (exit != null) {
                System.err.println(cause.getMessage());
                System.exit(exit.value());
            } else {
                cause.printStackTrace();
                System.exit(-1);
            }
        }
        catch (Exception alreadyHandled) {
            System.exit(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void main(Environment env, String[] args) throws Exception {
        Environment old = Environment.ENVIRONMENT_THREAD_LOCAL.get();
        Environment.ENVIRONMENT_THREAD_LOCAL.set(env);
        try {
            Object result = this.exec(args);
            if (result == null) {
                return;
            }
            PrintStream out = env.getOutput();
            if (result instanceof StreamingOutput) {
                ((StreamingOutput)result).write((OutputStream)out);
            } else if (result instanceof Iterable) {
                Iterable iterable = (Iterable)result;
                for (Object o : iterable) {
                    if (o == null) continue;
                    out.println(o.toString());
                }
            } else if (result instanceof String) {
                String string = (String)result;
                out.println(string);
                if (!string.endsWith("\n")) {
                    out.println();
                }
            } else {
                out.println(result);
            }
        }
        finally {
            Environment.ENVIRONMENT_THREAD_LOCAL.set(old);
        }
    }

    public Object exec(String ... args) throws Exception {
        List<String> list = Main.processSystemProperties(args);
        String command = list.size() == 0 ? "help" : list.remove(0);
        args = list.toArray(new String[list.size()]);
        Cmd cmd = this.commands.get(command);
        if (cmd == null) {
            PrintStream err = Environment.ENVIRONMENT_THREAD_LOCAL.get().getError();
            err.println("Unknown command: " + command);
            err.println();
            this.commands.get("help").exec(this.interceptors, new String[0]);
            throw new IllegalArgumentException();
        }
        return cmd.exec(this.interceptors, args);
    }

    public static List<String> processSystemProperties(String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        for (String arg : args) {
            if (arg.startsWith("-D")) {
                String name = arg.substring(arg.indexOf("-D") + 2, arg.indexOf("="));
                String value = arg.substring(arg.indexOf("=") + 1);
                Properties properties = Environment.ENVIRONMENT_THREAD_LOCAL.get().getProperties();
                properties.setProperty(name, value);
                continue;
            }
            list.add(arg);
        }
        return list;
    }

    @Override
    public Collection<String> complete(String buffer, int cursorPosition) {
        ArrayList<String> cmds = new ArrayList<String>();
        if (buffer == null || buffer.length() == 0) {
            Set<String> cmd = this.commands.keySet();
            for (String s : cmd) {
                cmds.add(s + " ");
            }
        } else {
            Cmd cmd;
            if (buffer.substring(0, cursorPosition).contains(" ") && (cmd = this.getCmd(buffer)) != null) {
                return cmd.complete(buffer, cursorPosition);
            }
            String prefix = buffer.substring(0, cursorPosition);
            for (String command : this.commands.keySet()) {
                if (!command.startsWith(prefix)) continue;
                cmds.add(command + " ");
            }
        }
        Collections.sort(cmds);
        return cmds;
    }

    private Cmd getCmd(String buffer) {
        String commandName = buffer.replaceAll("^(\\w*).*?$", "$1");
        for (String cmd : this.commands.keySet()) {
            if (!cmd.equals(commandName)) continue;
            return this.commands.get(cmd);
        }
        return null;
    }
}

