/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.crest.cmds.targets;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tomitribe.crest.cmds.targets.Target;
import org.tomitribe.crest.contexts.DefaultsContext;

public class Substitution {
    private static final Pattern PATTERN = Pattern.compile("(\\$\\{)([\\w.]+)(})");

    private Substitution() {
    }

    public static String format(Target target, Method method, String input, DefaultsContext df) {
        return Substitution.format(target, method, input, df, new HashSet<String>());
    }

    private static String format(Target target, Method method, String input, DefaultsContext df, Set<String> seen) {
        if (!seen.add(input)) {
            throw new IllegalStateException("Circular reference in " + input);
        }
        Matcher matcher = PATTERN.matcher(input);
        StringBuffer buf = new StringBuffer();
        while (matcher.find()) {
            String key = matcher.group(2);
            String value = df.find(target, method, key);
            if (value == null) continue;
            value = Substitution.format(target, method, value, df, seen).replace("\\", "\\\\");
            matcher.appendReplacement(buf, value);
        }
        matcher.appendTail(buf);
        return buf.toString();
    }
}

