/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.auth.signatures;

import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tomitribe.auth.signatures.Algorithm;
import org.tomitribe.auth.signatures.AuthenticationException;
import org.tomitribe.auth.signatures.Join;
import org.tomitribe.auth.signatures.MissingAlgorithmException;
import org.tomitribe.auth.signatures.MissingKeyIdException;
import org.tomitribe.auth.signatures.MissingSignatureException;
import org.tomitribe.auth.signatures.SigningAlgorithm;
import org.tomitribe.auth.signatures.UnparsableSignatureException;
import org.tomitribe.auth.signatures.UnsupportedAlgorithmException;

public class Signature {
    private final String keyId;
    private final SigningAlgorithm signingAlgorithm;
    private final Algorithm algorithm;
    private final String signature;
    private final List<String> headers;
    private final AlgorithmParameterSpec parameterSpec;
    private static final Pattern RFC_2617_PARAM = Pattern.compile("(\\w+)=\"([^\"]*)\"");

    public Signature(String keyId, String signingAlgorithm, String algorithm, AlgorithmParameterSpec parameterSpec, List<String> headers) {
        this(keyId, Signature.getSigningAlgorithm(signingAlgorithm), Signature.getAlgorithm(algorithm), parameterSpec, null, headers);
    }

    private static Algorithm getAlgorithm(String algorithm) {
        if (algorithm == null) {
            throw new IllegalArgumentException("Algorithm cannot be null");
        }
        return Algorithm.get(algorithm);
    }

    private static SigningAlgorithm getSigningAlgorithm(String scheme) {
        if (scheme == null) {
            throw new IllegalArgumentException("Signing scheme cannot be null");
        }
        return SigningAlgorithm.get(scheme);
    }

    public Signature(String keyId, String signingAlgorithm, String algorithm, AlgorithmParameterSpec parameterSpec, String signature, List<String> headers) {
        this(keyId, Signature.getSigningAlgorithm(signingAlgorithm), Signature.getAlgorithm(algorithm), parameterSpec, signature, headers);
    }

    public Signature(String keyId, SigningAlgorithm signingAlgorithm, Algorithm algorithm, AlgorithmParameterSpec parameterSpec, String signature, List<String> headers) {
        if (keyId == null || keyId.trim().isEmpty()) {
            throw new IllegalArgumentException("keyId is required.");
        }
        if (algorithm == null) {
            throw new IllegalArgumentException("algorithm is required.");
        }
        if (signingAlgorithm != null && signingAlgorithm.getSupportedAlgorithms() != null && !signingAlgorithm.getSupportedAlgorithms().contains((Object)algorithm)) {
            throw new IllegalArgumentException("Signing algorithm " + signingAlgorithm.getAlgorithmName() + " is not compatible with " + algorithm.getPortableName());
        }
        this.keyId = keyId;
        this.signingAlgorithm = signingAlgorithm;
        this.algorithm = algorithm;
        this.signature = signature;
        this.parameterSpec = parameterSpec;
        if (headers == null || headers.size() == 0) {
            List<String> list = Arrays.asList("date");
            this.headers = Collections.unmodifiableList(list);
        } else {
            this.headers = Collections.unmodifiableList(this.lowercase(headers));
        }
    }

    private List<String> lowercase(List<String> headers) {
        ArrayList<String> list = new ArrayList<String>(headers.size());
        for (String header : headers) {
            list.add(header.toLowerCase());
        }
        return list;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public SigningAlgorithm getSigningAlgorithm() {
        return this.signingAlgorithm;
    }

    public String getSignature() {
        return this.signature;
    }

    public AlgorithmParameterSpec getParameterSpec() {
        return this.parameterSpec;
    }

    public List<String> getHeaders() {
        return this.headers;
    }

    public static Signature fromString(String authorization, Algorithm algorithm) {
        try {
            String keyid;
            authorization = Signature.normalize(authorization);
            HashMap<String, String> map = new HashMap<String, String>();
            Matcher matcher = RFC_2617_PARAM.matcher(authorization);
            while (matcher.find()) {
                String key = matcher.group(1).toLowerCase();
                String value = matcher.group(2);
                map.put(key, value);
            }
            ArrayList<String> headers = new ArrayList<String>();
            String headerString = (String)map.get("headers");
            if (headerString != null) {
                Collections.addAll(headers, headerString.toLowerCase().split(" +"));
            }
            if ((keyid = (String)map.get("keyid")) == null) {
                throw new MissingKeyIdException();
            }
            String algorithmField = (String)map.get("algorithm");
            if (algorithmField == null) {
                throw new MissingAlgorithmException();
            }
            String signature = (String)map.get("signature");
            if (signature == null) {
                throw new MissingSignatureException();
            }
            SigningAlgorithm parsedSigningAlgorithm = null;
            try {
                parsedSigningAlgorithm = SigningAlgorithm.get(algorithmField);
            }
            catch (UnsupportedAlgorithmException unsupportedAlgorithmException) {
                // empty catch block
            }
            Algorithm parsedAlgorithm = null;
            try {
                parsedAlgorithm = Algorithm.get(algorithmField);
                if (algorithm != null && parsedAlgorithm.getPortableName() != algorithm.getPortableName()) {
                    throw new IllegalArgumentException("The algorithm does not match the value of the 'Authorization' header.");
                }
            }
            catch (UnsupportedAlgorithmException ex) {
                if (algorithm == null) {
                    throw new IllegalArgumentException("The algorithm is required.");
                }
                parsedAlgorithm = algorithm;
            }
            return new Signature(keyid, parsedSigningAlgorithm, parsedAlgorithm, null, signature, headers);
        }
        catch (AuthenticationException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new UnparsableSignatureException(authorization, e);
        }
    }

    private static String normalize(String authorization) {
        String start = "signature ";
        String prefix = authorization.substring(0, "signature ".length()).toLowerCase();
        if (prefix.equals("signature ")) {
            authorization = authorization.substring("signature ".length());
        }
        return authorization.trim();
    }

    public String toString() {
        return "Signature keyId=\"" + this.keyId + '\"' + ",algorithm=\"" + (Object)((Object)this.algorithm) + '\"' + ",headers=\"" + Join.join(" ", this.headers) + '\"' + ",signature=\"" + this.signature + '\"';
    }
}

