/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.arq;

import javax.script.ScriptException;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;
import org.topbraid.jenax.util.ExceptionUtil;
import org.topbraid.jenax.util.JenaDatatypes;
import org.topbraid.shacl.arq.SHACLARQFunction;
import org.topbraid.shacl.js.JSGraph;
import org.topbraid.shacl.js.JSScriptEngine;
import org.topbraid.shacl.js.SHACLScriptEngineManager;
import org.topbraid.shacl.js.model.JSFactory;
import org.topbraid.shacl.model.SHJSExecutable;
import org.topbraid.shacl.model.SHJSFunction;

public class SHACLJSARQFunction
extends SHACLARQFunction {
    private String functionName;

    public SHACLJSARQFunction(SHJSFunction shaclFunction) {
        super(shaclFunction);
        this.functionName = shaclFunction.getFunctionName();
        this.addParameters(shaclFunction);
    }

    @Override
    public NodeValue executeBody(Dataset dataset, Model dataModel, QuerySolution bindings) {
        if (this.functionName == null) {
            throw new IllegalArgumentException("Missing JavaScript function name of " + this.getSHACLFunction().getURI());
        }
        boolean nested = SHACLScriptEngineManager.begin();
        JSScriptEngine engine = SHACLScriptEngineManager.getCurrentEngine();
        SHJSExecutable as = (SHJSExecutable)this.getSHACLFunction().as(SHJSExecutable.class);
        JSGraph dataJSGraph = new JSGraph(dataModel.getGraph(), engine);
        try {
            engine.executeLibraries(as);
            engine.put("$data", dataJSGraph);
            Object result = engine.invokeFunction(this.functionName, bindings);
            if (result != null) {
                Node node = JSFactory.getNode(result);
                if (node != null) {
                    NodeValue nodeValue = NodeValue.makeNode((Node)node);
                    return nodeValue;
                }
                if (result instanceof String) {
                    NodeValue nodeValue = NodeValue.makeNode((Node)NodeFactory.createLiteral((String)((String)result)));
                    return nodeValue;
                }
                if (result instanceof Long) {
                    NodeValue nodeValue = NodeValue.makeNode((Node)JenaDatatypes.createInteger(((Long)result).intValue()).asNode());
                    return nodeValue;
                }
                if (result instanceof Integer) {
                    NodeValue nodeValue = NodeValue.makeNode((Node)JenaDatatypes.createInteger((Integer)result).asNode());
                    return nodeValue;
                }
                if (result instanceof Double) {
                    NodeValue nodeValue = NodeValue.makeDecimal((double)((Double)result));
                    return nodeValue;
                }
                if (result instanceof Boolean) {
                    NodeValue nodeValue = NodeValue.booleanReturn((boolean)((Boolean)result));
                    return nodeValue;
                }
            }
        }
        catch (ScriptException ex) {
            ExceptionUtil.throwUnchecked(ex);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ExprEvalException((Throwable)ex);
        }
        finally {
            dataJSGraph.close();
            SHACLScriptEngineManager.end(nested);
        }
        throw new ExprEvalException();
    }

    @Override
    protected String getQueryString() {
        return ((SHJSFunction)this.getSHACLFunction()).getFunctionName();
    }
}

