/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.engine;

import java.net.URI;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Statement;
import org.topbraid.jenax.progress.ProgressMonitor;
import org.topbraid.shacl.engine.ShapesGraph;
import org.topbraid.shacl.entailment.SHACLEntailment;
import org.topbraid.shacl.expr.NodeExpressionContext;
import org.topbraid.shacl.validation.DefaultShapesGraphProvider;
import org.topbraid.shacl.vocabulary.SH;

public abstract class AbstractEngine
implements NodeExpressionContext {
    protected Dataset dataset;
    protected ProgressMonitor monitor;
    protected ShapesGraph shapesGraph;
    protected URI shapesGraphURI;
    private Model shapesModel;

    protected AbstractEngine(Dataset dataset, ShapesGraph shapesGraph, URI shapesGraphURI) {
        if (shapesGraphURI == null) {
            shapesGraphURI = DefaultShapesGraphProvider.get().getDefaultShapesGraphURI(dataset);
        }
        this.dataset = dataset;
        this.shapesGraph = shapesGraph;
        this.shapesGraphURI = shapesGraphURI;
    }

    public void applyEntailments() throws InterruptedException {
        Model shapesModel = this.dataset.getNamedModel(this.shapesGraphURI.toString());
        for (Statement s : shapesModel.listStatements(null, SH.entailment, (RDFNode)null).toList()) {
            if (!s.getObject().isURIResource()) continue;
            if (SHACLEntailment.get().getEngine(s.getResource().getURI()) != null) {
                this.dataset = SHACLEntailment.get().withEntailment(this.dataset, this.shapesGraphURI, this.shapesGraph, s.getResource(), this.monitor);
                continue;
            }
            throw new UnsupportedOperationException("Unsupported entailment regime " + s.getResource());
        }
    }

    @Override
    public Dataset getDataset() {
        return this.dataset;
    }

    public ProgressMonitor getProgressMonitor() {
        return this.monitor;
    }

    @Override
    public ShapesGraph getShapesGraph() {
        return this.shapesGraph;
    }

    @Override
    public URI getShapesGraphURI() {
        return this.shapesGraphURI;
    }

    public Model getShapesModel() {
        if (this.shapesModel == null) {
            this.shapesModel = this.dataset.getNamedModel(this.shapesGraphURI.toString());
        }
        return this.shapesModel;
    }

    public void setProgressMonitor(ProgressMonitor value) {
        this.monitor = value;
    }
}

