/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.optimize;

import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDFS;
import org.topbraid.jenax.util.JenaNodeUtil;
import org.topbraid.shacl.optimize.ClassPropertyMetadata;

public class OWLClassPropertyMetadataPlugin
implements ClassPropertyMetadata.Plugin {
    @Override
    public void init(ClassPropertyMetadata cpm, Node classNode, Graph graph) {
        ExtendedIterator it = graph.find(classNode, RDFS.subClassOf.asNode(), Node.ANY);
        while (it.hasNext()) {
            Object value;
            Node localRange;
            Node superClass = ((Triple)it.next()).getObject();
            if (!superClass.isBlank() || !graph.contains(superClass, OWL.onProperty.asNode(), cpm.getPredicate())) continue;
            if (cpm.getLocalRange() == null && (localRange = JenaNodeUtil.getObject(superClass, OWL.allValuesFrom.asNode(), graph)) != null) {
                cpm.setLocalRange(localRange);
                it.close();
                break;
            }
            if (cpm.getMaxCount() != null) continue;
            Node maxCountNode = JenaNodeUtil.getObject(superClass, OWL.maxCardinality.asNode(), graph);
            if (maxCountNode == null) {
                maxCountNode = JenaNodeUtil.getObject(superClass, OWL.cardinality.asNode(), graph);
            }
            if (maxCountNode == null || !maxCountNode.isLiteral() || !((value = maxCountNode.getLiteralValue()) instanceof Number)) continue;
            cpm.setMaxCount(((Number)value).intValue());
        }
    }
}

