/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.validation;

import java.util.LinkedList;
import java.util.List;
import org.apache.jena.rdf.model.Resource;
import org.topbraid.shacl.validation.TargetPlugin;
import org.topbraid.shacl.validation.js.JSTargetPlugin;
import org.topbraid.shacl.validation.sparql.SPARQLTargetPlugin;

public class TargetPlugins {
    private static TargetPlugins singleton = new TargetPlugins();
    private final List<TargetPlugin> plugins = new LinkedList<TargetPlugin>();

    public static TargetPlugins get() {
        return singleton;
    }

    TargetPlugins() {
        this.init();
    }

    public void addPlugin(TargetPlugin plugin) {
        this.plugins.add(plugin);
    }

    public TargetPlugin getLanguageForTarget(Resource target) {
        for (TargetPlugin plugin : this.plugins) {
            if (!plugin.canExecuteTarget(target)) continue;
            return plugin;
        }
        return null;
    }

    private void init() {
        this.addPlugin(new SPARQLTargetPlugin());
        this.addPlugin(new JSTargetPlugin());
    }

    public void setJSPreferred(boolean value) {
        this.plugins.clear();
        if (value) {
            this.addPlugin(new JSTargetPlugin());
            this.addPlugin(new SPARQLTargetPlugin());
        } else {
            this.init();
        }
    }
}

