/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.expr.lib;

import java.util.HashSet;
import java.util.Set;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ClosableIterator;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NiceIterator;
import org.topbraid.shacl.expr.AbstractInputExpression;
import org.topbraid.shacl.expr.NodeExpression;
import org.topbraid.shacl.expr.NodeExpressionContext;
import org.topbraid.shacl.expr.NodeExpressionVisitor;

public class DistinctExpression
extends AbstractInputExpression {
    public DistinctExpression(RDFNode expr, NodeExpression input) {
        super(expr, input);
    }

    @Override
    public ExtendedIterator<RDFNode> eval(RDFNode focusNode, NodeExpressionContext context) {
        return DistinctExpression.distinct(this.evalInput(focusNode, context));
    }

    @Override
    public Resource getOutputShape(Resource contextShape) {
        return this.getInput().getOutputShape(contextShape);
    }

    @Override
    public String getTypeId() {
        return "distinct";
    }

    public static ExtendedIterator<RDFNode> distinct(ExtendedIterator<RDFNode> base) {
        HashSet<RDFNode> seen = new HashSet<RDFNode>();
        return DistinctExpression.recording(DistinctExpression.rejecting(base, seen), seen);
    }

    private static <T> ExtendedIterator<T> recording(final ClosableIterator<T> i, final Set<T> seen) {
        return new NiceIterator<T>(){

            public void remove() {
                i.remove();
            }

            public boolean hasNext() {
                return i.hasNext();
            }

            public T next() {
                Object x = i.next();
                seen.add(x);
                return x;
            }

            public void close() {
                i.close();
            }
        };
    }

    private static ExtendedIterator<RDFNode> rejecting(ExtendedIterator<RDFNode> i, Set<RDFNode> seen) {
        return i.filterDrop(seen::contains);
    }

    @Override
    public void visit(NodeExpressionVisitor visitor) {
        visitor.visit(this);
    }
}

