/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.js;

import java.util.HashSet;
import java.util.Set;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.topbraid.jenax.util.ExceptionUtil;
import org.topbraid.shacl.js.JSScriptEngine;
import org.topbraid.shacl.js.model.JSFactory;
import org.topbraid.shacl.js.model.JSTriple;
import org.topbraid.shacl.util.FailureLog;

public class JSGraph {
    protected JSScriptEngine engine;
    private Graph graph;
    private Set<JSTripleIterator> openIterators = new HashSet<JSTripleIterator>();

    public JSGraph(Graph graph, JSScriptEngine engine) {
        this.engine = engine;
        this.graph = graph;
    }

    public void close() {
        if (!this.openIterators.isEmpty()) {
            FailureLog.get().logWarning("JavaScript graph session ended but " + this.openIterators.size() + " iterators have not been closed. Make sure to close them programmatically to avoid resource leaks and locking problems.");
        }
        this.closeIterators();
    }

    public void closeIterators() {
        for (JSTripleIterator stream : this.openIterators) {
            stream.closeIterator();
        }
        this.openIterators.clear();
    }

    public Graph getGraph() {
        return this.graph;
    }

    public JSTripleIterator find(Object subjectSOM, Object predicateSOM, Object objectSOM) {
        Node subject = JSFactory.getNode(subjectSOM);
        Node predicate = JSFactory.getNode(predicateSOM);
        Node object = JSFactory.getNode(objectSOM);
        ExtendedIterator it = this.getGraph().find(subject, predicate, object);
        JSTripleIterator jsit = new JSTripleIterator((ExtendedIterator<Triple>)it);
        this.openIterators.add(jsit);
        return jsit;
    }

    public Object query() {
        try {
            return this.engine.invokeFunctionOrdered("RDFQuery", new Object[]{this});
        }
        catch (Exception ex) {
            throw ExceptionUtil.throwUnchecked(ex);
        }
    }

    public class JSTripleIterator {
        private ExtendedIterator<Triple> it;

        JSTripleIterator(ExtendedIterator<Triple> it) {
            this.it = it;
        }

        public void close() {
            this.closeIterator();
            JSGraph.this.openIterators.remove(this);
        }

        void closeIterator() {
            this.it.close();
        }

        public JSTriple next() {
            if (this.it.hasNext()) {
                Triple triple = (Triple)this.it.next();
                return JSFactory.asJSTriple(triple);
            }
            this.close();
            return null;
        }
    }
}

