/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.jena.ontology.OntDocumentManager;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.topbraid.jenax.util.JenaUtil;
import org.topbraid.jenax.util.SystemTriples;
import org.topbraid.shacl.compact.SHACLC;
import org.topbraid.shacl.util.SHACLSystemModel;

class AbstractTool {
    private static final String DATA_FILE = "-datafile";
    private static final String SHAPES_FILE = "-shapesfile";
    private OntDocumentManager dm = new OntDocumentManager();
    private OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_MEM);

    AbstractTool() {
        InputStream shaclTTL = SHACLSystemModel.class.getResourceAsStream("/rdf/shacl.ttl");
        Model shacl = JenaUtil.createMemoryModel();
        shacl.read(shaclTTL, "http://www.w3.org/ns/shacl#", "TURTLE");
        shacl.add(SystemTriples.getVocabularyModel());
        this.dm.addModel("http://www.w3.org/ns/shacl#", shacl);
        InputStream dashTTL = SHACLSystemModel.class.getResourceAsStream("/rdf/dash.ttl");
        Model dash = JenaUtil.createMemoryModel();
        dash.read(dashTTL, "http://www.w3.org/ns/shacl#", "TURTLE");
        this.dm.addModel("http://datashapes.org/dash", dash);
        InputStream toshTTL = SHACLSystemModel.class.getResourceAsStream("/rdf/tosh.ttl");
        Model tosh = JenaUtil.createMemoryModel();
        tosh.read(toshTTL, "http://www.w3.org/ns/shacl#", "TURTLE");
        this.dm.addModel("http://topbraid.org/tosh", tosh);
        this.spec.setDocumentManager(this.dm);
        SHACLC.install();
    }

    protected Model getDataModel(String[] args) throws IOException {
        for (int i = 0; i < args.length - 1; ++i) {
            if (!DATA_FILE.equals(args[i])) continue;
            String dataFileName = args[i + 1];
            OntModel dataModel = ModelFactory.createOntologyModel((OntModelSpec)this.spec);
            File file = new File(dataFileName);
            String lang = file.getName().endsWith(".shaclc") ? "SHACLC" : "TURTLE";
            dataModel.read((InputStream)new FileInputStream(file), "urn:x:base", lang);
            return dataModel;
        }
        System.err.println("Missing -datafile, e.g.: -datafile myfile.ttl");
        System.exit(0);
        return null;
    }

    protected Model getShapesModel(String[] args) throws IOException {
        for (int i = 0; i < args.length - 1; ++i) {
            if (!SHAPES_FILE.equals(args[i])) continue;
            String fileName = args[i + 1];
            OntModel model = ModelFactory.createOntologyModel((OntModelSpec)this.spec);
            File file = new File(fileName);
            String lang = file.getName().endsWith(".shaclc") ? "SHACLC" : "TURTLE";
            model.read((InputStream)new FileInputStream(file), "urn:x:base", lang);
            return model;
        }
        return null;
    }
}

