/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.validation.java;

import java.util.Collection;
import java.util.regex.Pattern;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.sparql.expr.RegexJava;
import org.apache.jena.sparql.expr.nodevalue.NodeFunctions;
import org.topbraid.jenax.util.JenaUtil;
import org.topbraid.shacl.engine.Constraint;
import org.topbraid.shacl.validation.AbstractNativeConstraintExecutor;
import org.topbraid.shacl.validation.ValidationEngine;
import org.topbraid.shacl.vocabulary.SH;

class PatternConstraintExecutor
extends AbstractNativeConstraintExecutor {
    private Pattern pattern;
    private String patternString;
    private String flagsStr;

    PatternConstraintExecutor(Constraint constraint) {
        this.flagsStr = JenaUtil.getStringProperty(constraint.getShapeResource(), SH.flags);
        this.patternString = JenaUtil.getStringProperty(constraint.getShapeResource(), SH.pattern);
        int flags = RegexJava.makeMask((String)this.flagsStr);
        if (this.flagsStr != null && this.flagsStr.contains("q")) {
            this.patternString = Pattern.quote(this.patternString);
        }
        this.pattern = Pattern.compile(this.patternString, flags);
    }

    @Override
    public void executeConstraint(Constraint constraint, ValidationEngine engine, Collection<RDFNode> focusNodes) {
        long startTime = System.currentTimeMillis();
        for (RDFNode focusNode : focusNodes) {
            for (RDFNode valueNode : engine.getValueNodes(constraint, focusNode)) {
                if (valueNode.isAnon()) {
                    engine.createValidationResult(constraint, focusNode, valueNode, () -> "Blank node cannot match pattern");
                    continue;
                }
                String str = NodeFunctions.str((Node)valueNode.asNode());
                if (this.pattern.matcher(str).find()) continue;
                engine.createValidationResult(constraint, focusNode, valueNode, () -> "Value does not match pattern \"" + this.patternString + "\"");
            }
            engine.checkCanceled();
        }
        this.addStatistics(constraint, startTime);
    }
}

