/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.validation.js;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.topbraid.shacl.engine.Constraint;
import org.topbraid.shacl.model.SHConstraintComponent;
import org.topbraid.shacl.model.SHJSConstraint;
import org.topbraid.shacl.model.SHJSExecutable;
import org.topbraid.shacl.validation.ValidationEngine;
import org.topbraid.shacl.validation.js.AbstractJSExecutor;
import org.topbraid.shacl.vocabulary.SH;

public class JSComponentExecutor
extends AbstractJSExecutor {
    @Override
    protected void addBindings(Constraint constraint, QuerySolutionMap bindings) {
        constraint.addBindings(bindings);
    }

    @Override
    protected SHJSExecutable getExecutable(Constraint constraint) {
        return (SHJSExecutable)constraint.getComponent().getValidator(SH.JSValidator, constraint.getContext()).as(SHJSConstraint.class);
    }

    @Override
    protected String getLabel(Constraint constraint) {
        return constraint.getComponent().getLocalName() + " (JavaScript constraint component executor)";
    }

    @Override
    protected Collection<RDFNode> getValueNodes(ValidationEngine validationEngine, Constraint constraint, QuerySolutionMap bindings, RDFNode focusNode) {
        SHConstraintComponent component = constraint.getComponent();
        Resource context = constraint.getContext();
        Resource validatorResource = component.getValidator(SH.JSValidator, context);
        if (SH.PropertyShape.equals((Object)context)) {
            if (component.hasProperty(SH.propertyValidator, (RDFNode)validatorResource)) {
                bindings.add("path", constraint.getShapeResource().getRequiredProperty(SH.path).getObject());
                ArrayList<RDFNode> valueNodes = new ArrayList<RDFNode>();
                valueNodes.add(null);
                return valueNodes;
            }
            return validationEngine.getValueNodes(constraint, focusNode);
        }
        bindings.add("value", focusNode);
        return Collections.singletonList(focusNode);
    }
}

