/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.validation.js;

import java.util.Collection;
import java.util.HashSet;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.topbraid.jenax.util.ExceptionUtil;
import org.topbraid.shacl.js.JSGraph;
import org.topbraid.shacl.js.JSScriptEngine;
import org.topbraid.shacl.js.NashornUtil;
import org.topbraid.shacl.js.SHACLScriptEngineManager;
import org.topbraid.shacl.js.model.JSFactory;
import org.topbraid.shacl.model.SHJSExecutable;
import org.topbraid.shacl.model.SHParameterizableTarget;
import org.topbraid.shacl.targets.Target;

public class JSTarget
implements Target {
    private SHJSExecutable as;
    private SHParameterizableTarget parameterizableTarget;

    JSTarget(Resource executable, SHParameterizableTarget parameterizableTarget) {
        this.as = parameterizableTarget != null ? (SHJSExecutable)parameterizableTarget.getParameterizable().as(SHJSExecutable.class) : (SHJSExecutable)executable.as(SHJSExecutable.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTargetNodes(Dataset dataset, Collection<RDFNode> results) {
        boolean nested = SHACLScriptEngineManager.begin();
        JSScriptEngine engine = SHACLScriptEngineManager.getCurrentEngine();
        Model model = dataset.getDefaultModel();
        JSGraph dataJSGraph = new JSGraph(model.getGraph(), engine);
        try {
            Object result;
            engine.executeLibraries(this.as);
            engine.put("$data", dataJSGraph);
            QuerySolutionMap bindings = new QuerySolutionMap();
            if (this.parameterizableTarget != null) {
                this.parameterizableTarget.addBindings(bindings);
            }
            if (NashornUtil.isArray(result = engine.invokeFunction(this.as.getFunctionName(), (QuerySolution)bindings))) {
                for (Object obj : NashornUtil.asArray(result)) {
                    Node node = JSFactory.getNode(obj);
                    results.add(model.asRDFNode(node));
                }
            }
        }
        catch (Exception ex) {
            ExceptionUtil.throwUnchecked(ex);
        }
        finally {
            dataJSGraph.close();
            SHACLScriptEngineManager.end(nested);
        }
    }

    @Override
    public boolean contains(Dataset dataset, RDFNode node) {
        HashSet<RDFNode> set = new HashSet<RDFNode>();
        this.addTargetNodes(dataset, set);
        return set.contains(node);
    }
}

