/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.compact;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.ReaderRIOTBase;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.NodeFactoryExtra;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.topbraid.jenax.util.ExceptionUtil;
import org.topbraid.jenax.util.JenaDatatypes;
import org.topbraid.jenax.util.JenaUtil;
import org.topbraid.shacl.compact.SHACLC;
import org.topbraid.shacl.compact.parser.SHACLCBaseListener;
import org.topbraid.shacl.compact.parser.SHACLCLexer;
import org.topbraid.shacl.compact.parser.SHACLCParser;
import org.topbraid.shacl.vocabulary.SH;

public class SHACLCReader
extends ReaderRIOTBase {
    private PrefixMapping prefixMapping = new PrefixMappingImpl();

    public SHACLCReader() {
        JenaUtil.initNamespaces(this.prefixMapping);
    }

    public void read(InputStream in, String baseURI, Lang lang, StreamRDF output, Context context) {
        try {
            SHACLCLexer lexer = new SHACLCLexer((CharStream)new ANTLRInputStream(in));
            this.read(lexer, baseURI, output);
        }
        catch (IOException ex) {
            ExceptionUtil.throwUnchecked(ex);
        }
    }

    public void read(Reader reader, String baseURI, ContentType ct, StreamRDF output, Context context) {
        try {
            SHACLCLexer lexer = new SHACLCLexer((CharStream)new ANTLRInputStream(reader));
            this.read(lexer, baseURI, output);
        }
        catch (IOException ex) {
            ExceptionUtil.throwUnchecked(ex);
        }
    }

    private void read(SHACLCLexer lexer, String baseURI, final StreamRDF output) {
        for (String prefix : SHACLC.getDefaultPrefixes()) {
            output.prefix(prefix, SHACLC.getDefaultPrefixURI(prefix));
        }
        final Node[] ontology = new Node[]{NodeFactory.createURI((String)baseURI)};
        final HashSet<Node> imports = new HashSet<Node>();
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        SHACLCParser parser = new SHACLCParser((TokenStream)tokens);
        SHACLCParser.ShaclDocContext docContext = parser.shaclDoc();
        ParseTreeWalker walker = new ParseTreeWalker();
        SHACLCBaseListener listener = new SHACLCBaseListener(){

            @Override
            public void exitBaseDecl(SHACLCParser.BaseDeclContext ctx) {
                String text = ctx.IRIREF().getText();
                String uri = text.substring(1, text.length() - 1);
                ontology[0] = NodeFactory.createURI((String)uri);
            }

            @Override
            public void exitImportsDecl(SHACLCParser.ImportsDeclContext ctx) {
                String text = ctx.IRIREF().getText();
                String uri = text.substring(1, text.length() - 1);
                imports.add(NodeFactory.createURI((String)uri));
            }

            @Override
            public void exitPrefixDecl(SHACLCParser.PrefixDeclContext ctx) {
                String prefixText = ctx.PNAME_NS().getText();
                String prefix = prefixText.substring(0, prefixText.length() - 1).trim();
                String nsText = ctx.IRIREF().getText();
                String ns = nsText.substring(1, nsText.length() - 1);
                output.prefix(prefix, ns);
                SHACLCReader.this.prefixMapping.setNsPrefix(prefix, ns);
            }

            @Override
            public void exitNodeShape(SHACLCParser.NodeShapeContext ctx) {
                Node nodeShape = this.getURI(ctx.iri().getText());
                output.triple(Triple.create((Node)nodeShape, (Node)RDF.type.asNode(), (Node)SH.NodeShape.asNode()));
                SHACLCParser.TargetClassContext targetClass = ctx.targetClass();
                if (targetClass != null) {
                    for (SHACLCParser.IriContext c : targetClass.iri()) {
                        Node object = this.getURI(c.getText());
                        output.triple(Triple.create((Node)nodeShape, (Node)SH.targetClass.asNode(), (Node)object));
                    }
                }
                this.parseConstraints(ctx.nodeShapeBody(), nodeShape);
            }

            private Node getNode(SHACLCParser.IriOrLiteralOrArrayContext c) {
                if (c.array() != null) {
                    LinkedList<Node> members = new LinkedList<Node>();
                    for (SHACLCParser.IriOrLiteralContext i : c.array().iriOrLiteral()) {
                        members.add(this.getNode(i));
                    }
                    return this.getNodeList(members.iterator());
                }
                return this.getNode(c.iriOrLiteral());
            }

            private Node getNodeList(Iterator<Node> it) {
                if (!it.hasNext()) {
                    return RDF.nil.asNode();
                }
                Node item = NodeFactory.createBlankNode();
                output.triple(Triple.create((Node)item, (Node)RDF.first.asNode(), (Node)it.next()));
                output.triple(Triple.create((Node)item, (Node)RDF.rest.asNode(), (Node)this.getNodeList(it)));
                return item;
            }

            private Node getNode(SHACLCParser.IriOrLiteralContext c) {
                if (c.iri() != null) {
                    return this.getURI(c.getText());
                }
                return NodeFactoryExtra.parseNode((String)c.literal().getText());
            }

            private Node getPath(SHACLCParser.PathContext c) {
                return this.getPathAlternative(c.pathAlternative());
            }

            private Node getPathAlternative(SHACLCParser.PathAlternativeContext c) {
                if (c.pathSequence().size() > 1) {
                    LinkedList<Node> members = new LinkedList<Node>();
                    for (SHACLCParser.PathSequenceContext s : c.pathSequence()) {
                        members.add(this.getPathSequence(s));
                    }
                    Node alt = NodeFactory.createBlankNode();
                    output.triple(Triple.create((Node)alt, (Node)SH.alternativePath.asNode(), (Node)this.getNodeList(members.iterator())));
                    return alt;
                }
                return this.getPathSequence(c.pathSequence(0));
            }

            private Node getPathSequence(SHACLCParser.PathSequenceContext c) {
                if (c.pathEltOrInverse().size() > 1) {
                    LinkedList<Node> members = new LinkedList<Node>();
                    for (SHACLCParser.PathEltOrInverseContext s : c.pathEltOrInverse()) {
                        members.add(this.getPathEltOrInverse(s));
                    }
                    return this.getNodeList(members.iterator());
                }
                return this.getPathEltOrInverse(c.pathEltOrInverse(0));
            }

            private Node getPathEltOrInverse(SHACLCParser.PathEltOrInverseContext c) {
                if (c.pathInverse() != null) {
                    Node inversePath = NodeFactory.createBlankNode();
                    output.triple(Triple.create((Node)inversePath, (Node)SH.inversePath.asNode(), (Node)this.getPathElt(c.pathElt())));
                    return inversePath;
                }
                return this.getPathElt(c.pathElt());
            }

            private Node getPathElt(SHACLCParser.PathEltContext c) {
                if (c.pathMod() != null) {
                    String symbol = c.pathMod().getText().trim();
                    Node predicate = "?".equals(symbol) ? SH.zeroOrOnePath.asNode() : ("+".equals(symbol) ? SH.oneOrMorePath.asNode() : SH.zeroOrMorePath.asNode());
                    Node path = NodeFactory.createBlankNode();
                    output.triple(Triple.create((Node)path, (Node)predicate, (Node)this.getPathPrimary(c.pathPrimary())));
                    return path;
                }
                return this.getPathPrimary(c.pathPrimary());
            }

            private Node getPathPrimary(SHACLCParser.PathPrimaryContext c) {
                if (c.iri() != null) {
                    return this.getURI(c.iri().getText());
                }
                return this.getPath(c.path());
            }

            @Override
            public void exitShapeClass(SHACLCParser.ShapeClassContext ctx) {
                Node nodeShape = this.getURI(ctx.iri().getText());
                output.triple(Triple.create((Node)nodeShape, (Node)RDF.type.asNode(), (Node)SH.NodeShape.asNode()));
                output.triple(Triple.create((Node)nodeShape, (Node)RDF.type.asNode(), (Node)RDFS.Class.asNode()));
                this.parseConstraints(ctx.nodeShapeBody(), nodeShape);
            }

            private Node getURI(String iriRef) {
                if (iriRef.startsWith("<")) {
                    return NodeFactory.createURI((String)iriRef.substring(1, iriRef.length() - 1));
                }
                String uri = SHACLCReader.this.prefixMapping.expandPrefix(iriRef);
                if (uri.equals(iriRef)) {
                    throw new RuntimeException("Undefined prefixed name " + iriRef);
                }
                return NodeFactory.createURI((String)uri);
            }

            private void parseConstraints(SHACLCParser.NodeShapeBodyContext ctx, Node nodeShape) {
                for (SHACLCParser.ConstraintContext c : ctx.constraint()) {
                    if (c.propertyShape() != null) {
                        this.parsePropertyShape(c.propertyShape(), nodeShape);
                        continue;
                    }
                    for (SHACLCParser.NodeOrContext nodeOr : c.nodeOr()) {
                        this.parseNodeOr(nodeOr, nodeShape);
                    }
                }
            }

            private void parseNodeOr(SHACLCParser.NodeOrContext ctx, Node shape) {
                if (ctx.nodeNot().size() > 1) {
                    LinkedList<Node> shapes = new LinkedList<Node>();
                    for (SHACLCParser.NodeNotContext c : ctx.nodeNot()) {
                        Node member = NodeFactory.createBlankNode();
                        this.parseNodeNot(c, member);
                        shapes.add(member);
                    }
                    Node or = this.getNodeList(shapes.iterator());
                    output.triple(Triple.create((Node)shape, (Node)SH.or.asNode(), (Node)or));
                } else {
                    for (SHACLCParser.NodeNotContext c : ctx.nodeNot()) {
                        this.parseNodeNot(c, shape);
                    }
                }
            }

            private void parseNodeNot(SHACLCParser.NodeNotContext ctx, Node parentShape) {
                if (ctx.negation() != null) {
                    Node not = NodeFactory.createBlankNode();
                    output.triple(Triple.create((Node)parentShape, (Node)SH.not.asNode(), (Node)not));
                    parentShape = not;
                }
                this.parseNodeValue(ctx.nodeValue(), parentShape);
            }

            private void parseNodeValue(SHACLCParser.NodeValueContext nodeValue, Node parentShape) {
                Node predicate = NodeFactory.createURI((String)("http://www.w3.org/ns/shacl#" + nodeValue.nodeParam().getText()));
                Node object = this.getNode(nodeValue.iriOrLiteralOrArray());
                output.triple(Triple.create((Node)parentShape, (Node)predicate, (Node)object));
            }

            private void parsePropertyShape(SHACLCParser.PropertyShapeContext ctx, Node parentShape) {
                Node propertyShape = NodeFactory.createBlankNode();
                output.triple(Triple.create((Node)parentShape, (Node)SH.property.asNode(), (Node)propertyShape));
                output.triple(Triple.create((Node)propertyShape, (Node)SH.path.asNode(), (Node)this.getPath(ctx.path())));
                for (SHACLCParser.PropertyCountContext propertyCountContext : ctx.propertyCount()) {
                    this.parsePropertyCount(propertyCountContext, propertyShape);
                }
                for (SHACLCParser.PropertyOrContext propertyOrContext : ctx.propertyOr()) {
                    this.parsePropertyOr(propertyOrContext, propertyShape);
                }
            }

            private void parsePropertyOr(SHACLCParser.PropertyOrContext ctx, Node shape) {
                if (ctx.propertyNot().size() > 1) {
                    LinkedList<Node> shapes = new LinkedList<Node>();
                    for (SHACLCParser.PropertyNotContext c : ctx.propertyNot()) {
                        Node member = NodeFactory.createBlankNode();
                        this.parsePropertyNot(c, member);
                        shapes.add(member);
                    }
                    Node or = this.getNodeList(shapes.iterator());
                    output.triple(Triple.create((Node)shape, (Node)SH.or.asNode(), (Node)or));
                } else {
                    for (SHACLCParser.PropertyNotContext c : ctx.propertyNot()) {
                        this.parsePropertyNot(c, shape);
                    }
                }
            }

            private void parsePropertyNot(SHACLCParser.PropertyNotContext ctx, Node parentShape) {
                if (ctx.negation() != null) {
                    Node not = NodeFactory.createBlankNode();
                    output.triple(Triple.create((Node)parentShape, (Node)SH.not.asNode(), (Node)not));
                    parentShape = not;
                }
                this.parsePropertyAtom(ctx.propertyAtom(), parentShape);
            }

            private void parsePropertyAtom(SHACLCParser.PropertyAtomContext ctx, Node shape) {
                if (ctx.nodeKind() != null) {
                    Node nodeKind = NodeFactory.createURI((String)("http://www.w3.org/ns/shacl#" + ctx.nodeKind().getText()));
                    output.triple(Triple.create((Node)shape, (Node)SH.nodeKind.asNode(), (Node)nodeKind));
                }
                if (ctx.propertyType() != null) {
                    Node value = this.getURI(ctx.propertyType().iri().getText());
                    if (JenaDatatypes.isSystemDatatype((RDFNode)ResourceFactory.createResource((String)value.getURI()))) {
                        output.triple(Triple.create((Node)shape, (Node)SH.datatype.asNode(), (Node)value));
                    } else {
                        output.triple(Triple.create((Node)shape, (Node)SH.class_.asNode(), (Node)value));
                    }
                }
                if (ctx.shapeRef() != null) {
                    String text = ctx.shapeRef().getText().trim().substring(1);
                    Node nodeShape = this.getURI(text);
                    output.triple(Triple.create((Node)shape, (Node)SH.node.asNode(), (Node)nodeShape));
                }
                if (ctx.propertyValue() != null) {
                    Node predicate = NodeFactory.createURI((String)("http://www.w3.org/ns/shacl#" + ctx.propertyValue().propertyParam().getText()));
                    Node object = this.getNode(ctx.propertyValue().iriOrLiteralOrArray());
                    output.triple(Triple.create((Node)shape, (Node)predicate, (Node)object));
                }
                if (ctx.nodeShapeBody() != null) {
                    Node nestedShape = NodeFactory.createBlankNode();
                    output.triple(Triple.create((Node)shape, (Node)SH.node.asNode(), (Node)nestedShape));
                    this.parseConstraints(ctx.nodeShapeBody(), nestedShape);
                }
            }

            private void parsePropertyCount(SHACLCParser.PropertyCountContext ctx, Node propertyShape) {
                Node minCount = NodeFactoryExtra.parseNode((String)ctx.propertyMinCount().INTEGER().getText());
                if (!"0".equals(minCount.getLiteralLexicalForm())) {
                    output.triple(Triple.create((Node)propertyShape, (Node)SH.minCount.asNode(), (Node)minCount));
                }
                if (!"*".equals(ctx.propertyMaxCount().getText())) {
                    Node maxCount = NodeFactoryExtra.parseNode((String)ctx.propertyMaxCount().INTEGER().getText());
                    output.triple(Triple.create((Node)propertyShape, (Node)SH.maxCount.asNode(), (Node)maxCount));
                }
            }
        };
        walker.walk((ParseTreeListener)listener, (ParseTree)docContext);
        output.triple(Triple.create((Node)ontology[0], (Node)RDF.type.asNode(), (Node)OWL.Ontology.asNode()));
        imports.add(NodeFactory.createURI((String)"http://datashapes.org/dash"));
        for (Node imp : imports) {
            output.triple(Triple.create((Node)ontology[0], (Node)OWL.imports.asNode(), (Node)imp));
        }
    }
}

