/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.validation.java;

import java.util.Collection;
import org.apache.jena.rdf.model.RDFNode;
import org.topbraid.shacl.engine.Constraint;
import org.topbraid.shacl.validation.AbstractNativeConstraintExecutor;
import org.topbraid.shacl.validation.ValidationEngine;

abstract class AbstractLengthConstraintExecutor
extends AbstractNativeConstraintExecutor {
    private int expectedLength;

    AbstractLengthConstraintExecutor(Constraint constraint) {
        this.expectedLength = constraint.getParameterValue().asLiteral().getInt();
    }

    @Override
    public void executeConstraint(Constraint constraint, ValidationEngine engine, Collection<RDFNode> focusNodes) {
        long startTime = System.currentTimeMillis();
        String message = "Value has " + this.getComparisonString() + " than " + this.expectedLength + " characters";
        if (constraint.getShapeResource().isPropertyShape()) {
            for (RDFNode focusNode : focusNodes) {
                for (RDFNode valueNode : engine.getValueNodes(constraint, focusNode)) {
                    this.validate(constraint, engine, message, this.expectedLength, focusNode, valueNode);
                }
                engine.checkCanceled();
            }
        } else {
            for (RDFNode focusNode : focusNodes) {
                this.validate(constraint, engine, message, this.expectedLength, focusNode, focusNode);
                engine.checkCanceled();
            }
        }
        this.addStatistics(constraint, startTime);
    }

    protected abstract String getComparisonString();

    protected abstract boolean isInvalidLength(int var1, int var2);

    private void validate(Constraint constraint, ValidationEngine engine, String message, int length, RDFNode focusNode, RDFNode valueNode) {
        if (valueNode.isAnon() || valueNode.isURIResource() && this.isInvalidLength(valueNode.asNode().getURI().length(), length) || valueNode.isLiteral() && this.isInvalidLength(valueNode.asNode().getLiteralLexicalForm().length(), length)) {
            engine.createValidationResult(constraint, focusNode, valueNode, () -> message);
        }
    }
}

