/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.validation.js;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.sparql.expr.ExprNotComparableException;
import org.apache.jena.sparql.expr.NodeValue;
import org.topbraid.shacl.engine.ShapesGraph;
import org.topbraid.shacl.js.model.JSTerm;
import org.topbraid.shacl.util.RecursionGuard;
import org.topbraid.shacl.validation.ValidationEngineFactory;

public class SHACLObject {
    private Dataset dataset;
    private ShapesGraph shapesGraph;
    private URI shapesGraphURI;

    public SHACLObject(ShapesGraph shapesGraph, URI shapesGraphURI, Dataset dataset) {
        this.shapesGraph = shapesGraph;
        this.shapesGraphURI = shapesGraphURI;
        this.dataset = dataset;
    }

    public Integer compareNodes(JSTerm node1, JSTerm node2) {
        try {
            if (node1.isURI() && node2.isURI()) {
                return node1.getUri().compareTo(node2.getUri());
            }
            return NodeValue.compare((NodeValue)NodeValue.makeNode((Node)node1.getNode()), (NodeValue)NodeValue.makeNode((Node)node2.getNode()));
        }
        catch (ExprNotComparableException ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean nodeConformsToShape(JSTerm node, JSTerm shape) {
        try {
            if (RecursionGuard.start(node.getNode(), shape.getNode())) {
                boolean bl = true;
                return bl;
            }
            List<RDFNode> focusNodes = Collections.singletonList(this.dataset.getDefaultModel().asRDFNode(node.getNode()));
            boolean bl = ValidationEngineFactory.get().create(this.dataset, this.shapesGraphURI, this.shapesGraph, null).nodesConformToShape(focusNodes, shape.getNode());
            return bl;
        }
        finally {
            RecursionGuard.end(node.getNode(), shape.getNode());
        }
    }
}

