/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.jenax.functions;

import java.util.HashMap;
import java.util.Map;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.function.FunctionFactory;
import org.topbraid.jenax.functions.DeclarativeFunctionDrivers;
import org.topbraid.jenax.functions.DeclarativeFunctionFactory;

public class CurrentThreadFunctions {
    private Map<String, FunctionFactory> functionsCache = new HashMap<String, FunctionFactory>();
    private Model model;

    CurrentThreadFunctions(Model model) {
        this.model = model;
    }

    FunctionFactory getFunctionFactory(String uri) {
        FunctionFactory old = this.functionsCache.get(uri);
        if (old != null) {
            return old;
        }
        if (this.functionsCache.containsKey(uri)) {
            return null;
        }
        return this.getFunctionFactoryFromModel(uri);
    }

    private FunctionFactory getFunctionFactoryFromModel(String uri) {
        Resource functionResource = this.model.getResource(uri);
        DeclarativeFunctionDrivers drivers = DeclarativeFunctionDrivers.get();
        if (drivers == null) {
            return null;
        }
        DeclarativeFunctionFactory arqFunction = drivers.create(functionResource);
        if (arqFunction != null) {
            this.functionsCache.put(uri, arqFunction);
            return arqFunction;
        }
        this.functionsCache.put(uri, null);
        return null;
    }
}

