/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.arq;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Substitute;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.Function;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.util.ExprUtils;
import org.apache.jena.sparql.util.FmtUtils;
import org.topbraid.jenax.functions.DeclarativeFunctionFactory;
import org.topbraid.jenax.functions.OptionalArgsFunction;
import org.topbraid.jenax.statistics.ExecStatistics;
import org.topbraid.jenax.statistics.ExecStatisticsManager;
import org.topbraid.jenax.util.JenaDatatypes;
import org.topbraid.jenax.util.JenaUtil;
import org.topbraid.shacl.arq.SHACLFunctionsCache;
import org.topbraid.shacl.model.SHFunction;
import org.topbraid.shacl.model.SHParameter;
import org.topbraid.shacl.model.SHParameterizable;
import org.topbraid.shacl.vocabulary.DASH;

public abstract class SHACLARQFunction
implements Function,
OptionalArgsFunction,
DeclarativeFunctionFactory {
    private boolean cachable;
    protected List<String> paramNames = new ArrayList<String>();
    private List<Boolean> optional = new ArrayList<Boolean>();
    private SHFunction shFunction;

    protected SHACLARQFunction(SHFunction shaclFunction) {
        this.shFunction = shaclFunction;
        if (shaclFunction != null) {
            this.cachable = shaclFunction.hasProperty(DASH.cachable, (RDFNode)JenaDatatypes.TRUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addParameters(SHParameterizable parameterizable) {
        JenaUtil.setGraphReadOptimization(true);
        try {
            for (SHParameter param : parameterizable.getOrderedParameters()) {
                String varName = param.getVarName();
                if (varName == null) {
                    throw new IllegalStateException(param + " of " + parameterizable + " does not have a valid predicate");
                }
                this.paramNames.add(varName);
                this.optional.add(param.isOptional());
            }
        }
        finally {
            JenaUtil.setGraphReadOptimization(false);
        }
    }

    public void build(String uri, ExprList args) {
    }

    public Function create(String uri) {
        return this;
    }

    public NodeValue exec(Binding binding, ExprList args, String uri, FunctionEnv env) {
        Graph activeGraph = env.getActiveGraph();
        Model model = activeGraph != null ? ModelFactory.createModelForGraph((Graph)activeGraph) : ModelFactory.createDefaultModel();
        QuerySolutionMap bindings = new QuerySolutionMap();
        Node[] paramsForCache = this.cachable ? new Node[args.size()] : null;
        for (int i = 0; i < args.size(); ++i) {
            Expr expr = args.get(i);
            if (expr == null || expr.isVariable() && !binding.contains(expr.asVar())) continue;
            NodeValue x = expr.eval(binding, env);
            if (x != null) {
                Object paramName = i < this.paramNames.size() ? this.paramNames.get(i) : "arg" + (i + 1);
                bindings.add((String)paramName, model.asRDFNode(x.asNode()));
                if (!this.cachable) continue;
                paramsForCache[i] = x.asNode();
                continue;
            }
            if (this.optional.get(i).booleanValue()) continue;
            throw new ExprEvalException("Missing SHACL function argument");
        }
        Dataset dataset = DatasetFactory.wrap((DatasetGraph)env.getDataset());
        if (ExecStatisticsManager.get().isRecording() && ExecStatisticsManager.get().isRecordingDeclarativeFunctions()) {
            NodeValue result;
            StringBuffer sb = new StringBuffer();
            sb.append("SHACL Function ");
            sb.append(SSE.str((Node)NodeFactory.createURI((String)uri), (PrefixMapping)model));
            sb.append("(");
            for (int i = 0; i < args.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                Expr expr = args.get(i);
                if ((expr = Substitute.substitute((Expr)expr, (Binding)binding)) == null) {
                    sb.append("?unbound");
                    continue;
                }
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                IndentedWriter iOut = new IndentedWriter((OutputStream)bos);
                ExprUtils.fmtSPARQL((IndentedWriter)iOut, (Expr)expr, (SerializationContext)new SerializationContext((PrefixMapping)model));
                iOut.flush();
                sb.append(bos.toString());
            }
            sb.append(")");
            long startTime = System.currentTimeMillis();
            try {
                result = this.cachable ? SHACLFunctionsCache.get().execute(this, dataset, model, (QuerySolution)bindings, paramsForCache) : this.executeBody(dataset, model, (QuerySolution)bindings);
                sb.append(" = ");
                sb.append(FmtUtils.stringForNode((Node)result.asNode(), (PrefixMapping)model));
            }
            catch (ExprEvalException ex) {
                sb.append(" : ");
                sb.append(ex.getLocalizedMessage());
                throw ex;
            }
            finally {
                long endTime = System.currentTimeMillis();
                ExecStatistics stats = new ExecStatistics(sb.toString(), this.getQueryString(), endTime - startTime, startTime, NodeFactory.createURI((String)uri));
                ExecStatisticsManager.get().addSilently(Collections.singleton(stats));
            }
            return result;
        }
        if (this.cachable) {
            return SHACLFunctionsCache.get().execute(this, dataset, model, (QuerySolution)bindings, paramsForCache);
        }
        return this.executeBody(dataset, model, (QuerySolution)bindings);
    }

    public abstract NodeValue executeBody(Dataset var1, Model var2, QuerySolution var3);

    protected abstract String getQueryString();

    public SHFunction getSHACLFunction() {
        return this.shFunction;
    }

    public String[] getParamNames() {
        return this.paramNames.toArray(new String[0]);
    }

    @Override
    public boolean isOptionalArg(int index) {
        return this.optional.get(index);
    }
}

