/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.multifunctions;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Substitute;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBuilder;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.pfunction.PropFuncArg;
import org.apache.jena.sparql.pfunction.PropertyFunction;
import org.apache.jena.sparql.pfunction.PropertyFunctionBase;
import org.apache.jena.sparql.pfunction.PropertyFunctionFactory;
import org.topbraid.shacl.multifunctions.MultiFunction;
import org.topbraid.shacl.multifunctions.MultiFunctionParameter;

class MultiFunctionPropertyFunction
extends PropertyFunctionBase
implements PropertyFunctionFactory {
    private MultiFunction multiFunction;

    MultiFunctionPropertyFunction(MultiFunction multiFunction) {
        this.multiFunction = multiFunction;
    }

    public PropertyFunction create(String uri) {
        return this;
    }

    public QueryIterator exec(Binding parentBinding, PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
        argSubject = Substitute.substitute((PropFuncArg)argSubject, (Binding)parentBinding);
        List<Node> args = this.args(argSubject);
        argObject = Substitute.substitute((PropFuncArg)argObject, (Binding)parentBinding);
        Map<String, Var> vars = this.varsMap(argObject, predicate);
        QueryIterator quit = this.multiFunction.execute(args, execCxt.getActiveGraph(), execCxt.getDataset());
        Iterator bindings = Iter.map((Iterator)quit, binding -> this.convert((Binding)binding, vars, parentBinding));
        return QueryIterPlainWrapper.create((Iterator)bindings);
    }

    private List<Node> args(PropFuncArg argSubject) {
        if (argSubject.isList()) {
            LinkedList<Node> results = new LinkedList<Node>();
            for (Node arg : argSubject.getArgList()) {
                if (arg.isVariable()) {
                    results.add(null);
                    continue;
                }
                results.add(arg);
            }
            return results;
        }
        Node arg = argSubject.getArg();
        if (arg.isVariable()) {
            return Collections.singletonList(null);
        }
        return Collections.singletonList(arg);
    }

    private Binding convert(Binding binding, Map<String, Var> varsMap, Binding parentBinding) {
        BindingBuilder builder = BindingBuilder.create((Binding)parentBinding);
        Iterator vars = binding.vars();
        while (vars.hasNext()) {
            Var var2;
            Var var = (Var)vars.next();
            Node resultNode = binding.get(var);
            if (resultNode == null || (var2 = varsMap.get(var.getVarName())) == null) continue;
            builder.add(var2, resultNode);
        }
        return builder.build();
    }

    private Map<String, Var> varsMap(PropFuncArg argObject, Node predicate) {
        List<MultiFunctionParameter> vars = this.multiFunction.getResultVars();
        HashMap<String, Var> map = new HashMap<String, Var>();
        if (argObject.isList()) {
            List argList = argObject.getArgList();
            for (int i = 0; i < argList.size() && i < vars.size(); ++i) {
                Node arg = (Node)argList.get(i);
                if (!arg.isVariable()) {
                    throw new ExprEvalException("Nodes on the right side of property function " + predicate + " must be unbound variables");
                }
                String varName = vars.get(i).getName();
                map.put(varName, Var.alloc((Node)arg));
            }
        } else {
            Node arg = argObject.getArg();
            if (arg.isVariable()) {
                String varName = vars.get(0).getName();
                map.put(varName, Var.alloc((Node)arg));
            } else {
                throw new ExprEvalException("Nodes on the right side of property function " + predicate + " must be unbound variables");
            }
        }
        return map;
    }
}

