/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.optimize;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import org.apache.jena.ext.com.google.common.cache.Cache;
import org.apache.jena.ext.com.google.common.cache.CacheBuilder;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.topbraid.jenax.util.ARQFactory;
import org.topbraid.jenax.util.ExceptionUtil;
import org.topbraid.jenax.util.JenaUtil;
import org.topbraid.shacl.engine.ShapesGraph;
import org.topbraid.shacl.engine.ShapesGraphFactory;
import org.topbraid.shacl.optimize.ClassMetadata;
import org.topbraid.shacl.optimize.OntologyOptimizableGraph;
import org.topbraid.shacl.optimize.OptimizedMultiUnion;

public class OntologyOptimizations {
    static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static OntologyOptimizations singleton = new OntologyOptimizations();
    private boolean enabled;
    private long resetTimeStamp = System.currentTimeMillis();
    private static final int capacity = 10000;
    private Cache<Object, Object> cache = CacheBuilder.newBuilder().maximumSize(10000L).build();

    public static OntologyOptimizations get() {
        return singleton;
    }

    public static void set(OntologyOptimizations value) {
        singleton = value;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean value) {
        this.enabled = value;
    }

    public String getKeyIfEnabledFor(Graph graph) {
        Graph baseGraph;
        if (this.enabled && graph instanceof OptimizedMultiUnion && (baseGraph = JenaUtil.getBaseGraph(graph)) instanceof OntologyOptimizableGraph && ((OntologyOptimizableGraph)baseGraph).isUsingOntologyOptimizations()) {
            return ((OntologyOptimizableGraph)baseGraph).getOntologyGraphKey();
        }
        return null;
    }

    public ClassMetadata getClassMetadata(Node cls, Graph graph, String graphKey) {
        Object cacheKey = ClassMetadata.createKey(cls, graphKey);
        return (ClassMetadata)this.getOrComputeObject(cacheKey, () -> new ClassMetadata(cls, graphKey));
    }

    public Object getObject(Object key) {
        return this.cache.getIfPresent(key);
    }

    public Object getOrComputeObject(Object key, Function<Object, Object> function) {
        return this.getOrComputeObject(key, () -> function.apply(key));
    }

    public Object getOrComputeObject(Object key, Callable<Object> callable) {
        try {
            return this.cache.get(key, callable);
        }
        catch (ExecutionException ex) {
            log.error("Failed to populate OntologyOptimizations with key " + key, (Throwable)ex);
            throw ExceptionUtil.throwUnchecked(ex);
        }
    }

    public ShapesGraph getCachableShapesGraph(String uri) {
        String key = "CachableShapesGraph-" + uri;
        return (ShapesGraph)OntologyOptimizations.get().getOrComputeObject((Object)key, (Object u) -> {
            Model shapesModel = ARQFactory.getNamedModel(uri);
            return ShapesGraphFactory.get().createShapesGraph(shapesModel);
        });
    }

    public long getResetTimeStamp() {
        return this.resetTimeStamp;
    }

    public List<Object> keys() {
        return new ArrayList<Object>(this.cache.asMap().keySet());
    }

    public void perhapsReset(Graph graph) {
        if ((graph = JenaUtil.getBaseGraph(graph)) instanceof OntologyOptimizableGraph) {
            if (((OntologyOptimizableGraph)graph).isOntologyGraph()) {
                this.reset();
            }
        } else if (!JenaUtil.isMemoryGraph(graph)) {
            this.reset();
        }
    }

    public void putObject(Object key, Object value) {
        this.cache.put(key, value);
    }

    public void reset() {
        this.cache.invalidateAll();
        this.resetTimeStamp = System.currentTimeMillis();
    }
}

