/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.rules;

import java.util.HashMap;
import java.util.Map;
import org.apache.jena.rdf.model.Resource;
import org.topbraid.jenax.util.JenaUtil;
import org.topbraid.shacl.rules.RuleLanguage;
import org.topbraid.shacl.rules.SPARQLRuleLanguage;
import org.topbraid.shacl.rules.TripleRuleLanguage;
import org.topbraid.shacl.vocabulary.SH;

public class RuleLanguages {
    private static RuleLanguages singleton = new RuleLanguages();
    private Map<Resource, RuleLanguage> languages = new HashMap<Resource, RuleLanguage>();

    public static RuleLanguages get() {
        return singleton;
    }

    protected RuleLanguages() {
        this.addLanguage(SH.SPARQLRule, new SPARQLRuleLanguage());
        this.addLanguage(SH.TripleRule, new TripleRuleLanguage());
    }

    public void addLanguage(Resource type, RuleLanguage language) {
        this.languages.put(type, language);
    }

    public RuleLanguage getRuleLanguage(Resource rule) {
        Resource type = JenaUtil.getType(rule);
        return this.languages.get(type);
    }
}

