/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.validation;

import java.util.HashSet;
import java.util.Set;
import org.apache.jena.rdf.model.Resource;

public class ValidationEngineConfiguration {
    private boolean reportDetails = false;
    private Set<Resource> skippedConstraintComponents = new HashSet<Resource>();
    private boolean validateShapes = true;
    private int validationErrorBatch = -1;

    public ValidationEngineConfiguration clone() {
        ValidationEngineConfiguration c = new ValidationEngineConfiguration();
        c.reportDetails = this.reportDetails;
        c.skippedConstraintComponents = new HashSet<Resource>(this.skippedConstraintComponents);
        c.validateShapes = this.validateShapes;
        c.validationErrorBatch = this.validationErrorBatch;
        return c;
    }

    public boolean getReportDetails() {
        return this.reportDetails;
    }

    public ValidationEngineConfiguration setReportDetails(boolean reportDetails) {
        this.reportDetails = reportDetails;
        return this;
    }

    public int getValidationErrorBatch() {
        return this.validationErrorBatch;
    }

    public ValidationEngineConfiguration setValidationErrorBatch(int validationErrorBatch) {
        this.validationErrorBatch = validationErrorBatch;
        return this;
    }

    public boolean getValidateShapes() {
        return this.validateShapes;
    }

    public ValidationEngineConfiguration setValidateShapes(boolean validateShapes) {
        this.validateShapes = validateShapes;
        return this;
    }

    public boolean isSkippedConstraintComponent(Resource component) {
        return this.skippedConstraintComponents.contains(component);
    }

    public void addSkippedConstraintComponent(Resource component) {
        this.skippedConstraintComponents.add(component);
    }
}

