/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.validation;

import java.net.URI;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.compose.MultiUnion;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.RDF;
import org.topbraid.jenax.util.ARQFactory;
import org.topbraid.shacl.arq.SHACLFunctions;
import org.topbraid.shacl.engine.ShapesGraph;
import org.topbraid.shacl.engine.ShapesGraphFactory;
import org.topbraid.shacl.util.SHACLSystemModel;
import org.topbraid.shacl.util.SHACLUtil;
import org.topbraid.shacl.validation.ValidationEngine;
import org.topbraid.shacl.validation.ValidationEngineConfiguration;
import org.topbraid.shacl.validation.ValidationEngineFactory;
import org.topbraid.shacl.vocabulary.TOSH;

public class ValidationUtil {
    public static ValidationEngine createValidationEngine(Model dataModel, Model shapesModel, boolean validateShapes) {
        return ValidationUtil.createValidationEngine(dataModel, shapesModel, new ValidationEngineConfiguration().setValidateShapes(validateShapes));
    }

    public static ValidationEngine createValidationEngine(Model dataModel, Model shapesModel, ValidationEngineConfiguration configuration) {
        shapesModel = ValidationUtil.ensureToshTriplesExist(shapesModel);
        SHACLFunctions.registerFunctions(shapesModel);
        URI shapesGraphURI = SHACLUtil.createRandomShapesGraphURI();
        Dataset dataset = ARQFactory.get().getDataset(dataModel);
        dataset.addNamedModel(shapesGraphURI.toString(), shapesModel);
        ShapesGraph shapesGraph = ShapesGraphFactory.get().createShapesGraph(shapesModel);
        ValidationEngine engine = ValidationEngineFactory.get().create(dataset, shapesGraphURI, shapesGraph, null);
        engine.setConfiguration(configuration);
        return engine;
    }

    public static Model ensureToshTriplesExist(Model shapesModel) {
        if (!shapesModel.contains(TOSH.hasShape, RDF.type, (RDFNode)null)) {
            Model unionModel = SHACLSystemModel.getSHACLModel();
            MultiUnion unionGraph = new MultiUnion(new Graph[]{unionModel.getGraph(), shapesModel.getGraph()});
            shapesModel = ModelFactory.createModelForGraph((Graph)unionGraph);
        }
        return shapesModel;
    }

    public static Resource validateModel(Model dataModel, Model shapesModel, boolean validateShapes) {
        return ValidationUtil.validateModel(dataModel, shapesModel, new ValidationEngineConfiguration().setValidateShapes(validateShapes));
    }

    public static Resource validateModel(Model dataModel, Model shapesModel, ValidationEngineConfiguration configuration) {
        ValidationEngine engine = ValidationUtil.createValidationEngine(dataModel, shapesModel, configuration);
        engine.setConfiguration(configuration);
        try {
            engine.applyEntailments();
            return engine.validateAll();
        }
        catch (InterruptedException ex) {
            return null;
        }
    }
}

