/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.validation.java;

import java.util.Collection;
import org.apache.jena.rdf.model.RDFNode;
import org.topbraid.shacl.engine.Constraint;
import org.topbraid.shacl.validation.AbstractNativeConstraintExecutor;
import org.topbraid.shacl.validation.ValidationEngine;

class MaxCountConstraintExecutor
extends AbstractNativeConstraintExecutor {
    private int maxCount;

    MaxCountConstraintExecutor(Constraint constraint) {
        this.maxCount = constraint.getParameterValue().asLiteral().getInt();
    }

    @Override
    public void executeConstraint(Constraint constraint, ValidationEngine engine, Collection<RDFNode> focusNodes) {
        long startTime = System.currentTimeMillis();
        long valueNodeCount = 0L;
        for (RDFNode focusNode : focusNodes) {
            int count = engine.getValueNodes(constraint, focusNode).size();
            valueNodeCount += (long)count;
            if (count > this.maxCount) {
                engine.createValidationResult(constraint, focusNode, null, () -> "Property may only have " + this.maxCount + " value" + (this.maxCount == 1 ? "" : "s") + ", but found " + count);
            }
            engine.checkCanceled();
        }
        this.addStatistics(engine, constraint, startTime, focusNodes.size(), valueNodeCount);
    }
}

