/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.validation.java;

import java.util.Collection;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.topbraid.shacl.engine.Constraint;
import org.topbraid.shacl.validation.ValidationEngine;
import org.topbraid.shacl.validation.java.AbstractShapeListConstraintExecutor;

class XoneConstraintExecutor
extends AbstractShapeListConstraintExecutor {
    XoneConstraintExecutor(Constraint constraint) {
        super(constraint);
    }

    @Override
    public void executeConstraint(Constraint constraint, ValidationEngine engine, Collection<RDFNode> focusNodes) {
        long startTime = System.currentTimeMillis();
        long valueNodeCount = 0L;
        for (RDFNode focusNode : focusNodes) {
            for (RDFNode valueNode : engine.getValueNodes(constraint, focusNode)) {
                ++valueNodeCount;
                long count = this.shapes.stream().filter(shape -> {
                    Model nestedResults = this.hasShape(engine, constraint, focusNode, valueNode, (RDFNode)shape, true);
                    return nestedResults == null;
                }).count();
                if (count == 1L) continue;
                engine.createValidationResult(constraint, focusNode, valueNode, () -> "Value must have exactly one of the following " + this.shapes.size() + " shapes but conforms to " + count + ": " + this.shapeLabelsList(engine));
            }
        }
        this.addStatistics(engine, constraint, startTime, focusNodes.size(), valueNodeCount);
    }
}

