/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.jenax.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;

public class ExceptionUtil {
    public static RuntimeException throwRootCauseUnchecked(Throwable t) {
        return ExceptionUtil.throwDeepCauseChecked(t, RuntimeException.class);
    }

    public static RuntimeException throwUnchecked(Throwable t) {
        if (t == null) {
            throw new NullPointerException();
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new RuntimeException(t);
    }

    public static <EX extends Throwable> EX throwDeepCauseChecked(Throwable t, Class<? extends EX> clazz) throws EX {
        if (t == null) {
            throw new NullPointerException();
        }
        Error firstError = null;
        Object firstEX = null;
        RuntimeException firstRTE = null;
        for (Throwable tt = t; tt != null; tt = tt.getCause()) {
            firstError = ExceptionUtil.chooseNonNullCorrectClass(Error.class, firstError, tt);
            firstEX = ExceptionUtil.chooseNonNullCorrectClass(clazz, firstEX, tt);
            firstRTE = ExceptionUtil.chooseNonNullCorrectClass(RuntimeException.class, firstRTE, tt);
        }
        if (firstError != null) {
            throw firstError;
        }
        if (firstEX != null) {
            throw firstEX;
        }
        if (firstRTE != null) {
            throw firstRTE;
        }
        Throwable rslt = null;
        try {
            rslt = (Throwable)clazz.getConstructor(Throwable.class).newInstance(t);
        }
        catch (Exception e) {
            try {
                rslt = (Throwable)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                rslt.initCause(t);
            }
            catch (Exception e1) {
                if (e1.getCause() == null) {
                    e1.initCause(t);
                }
                throw new IllegalArgumentException(clazz.getName() + " does not have a functioning constructor, with either no arguments or a Throwable argument.", e1);
            }
        }
        throw rslt;
    }

    public static String getDeepMessage(Throwable t) {
        String msg = t.getMessage();
        if (t.getCause() == null) {
            return msg;
        }
        if (msg == null) {
            return ExceptionUtil.getDeepMessage(t.getCause());
        }
        if (msg.equals(t.getCause().toString())) {
            return ExceptionUtil.getDeepMessage(t.getCause());
        }
        return msg;
    }

    public static String getStackTrace(Throwable t) {
        if (t == null) {
            return null;
        }
        StringWriter writer = new StringWriter();
        t.printStackTrace(new PrintWriter(writer));
        return writer.getBuffer().toString();
    }

    private static <TT extends Throwable> TT chooseNonNullCorrectClass(Class<? extends TT> clazz, TT firstError, Throwable tt) {
        if (firstError != null) {
            return firstError;
        }
        if (clazz.isInstance(tt)) {
            return (TT)tt;
        }
        return null;
    }

    public static boolean hasDeepCause(Throwable t, Class<? extends Throwable> throwableClass) {
        return t != null && ExceptionUtil.getDeepCause(t, throwableClass) != null;
    }

    public static <EX extends Throwable> EX getDeepCause(Throwable t, Class<? extends EX> clazz) {
        if (t == null) {
            throw new NullPointerException();
        }
        for (Throwable tt = t; tt != null; tt = tt.getCause()) {
            if (!clazz.isInstance(tt)) continue;
            return (EX)tt;
        }
        return null;
    }

    public static String shortenStackTrace(String stackTrace, String shallowestInterestingMethod) {
        int idx = stackTrace.indexOf("\tat " + shallowestInterestingMethod + "(");
        if (idx < 0) {
            return stackTrace;
        }
        int boringStart = stackTrace.indexOf(System.lineSeparator(), idx);
        if (boringStart < 0) {
            return stackTrace;
        }
        StringBuilder result = new StringBuilder(stackTrace.substring(0, boringStart += System.lineSeparator().length()));
        result.append("\t... Rest omitted");
        result.append(System.lineSeparator());
        int causeStart = stackTrace.indexOf("Caused by:", boringStart);
        int suppressedStart = stackTrace.indexOf("Suppressed:", boringStart);
        if (causeStart >= 0 || suppressedStart >= 0) {
            result.append(stackTrace.substring(Math.max(causeStart, suppressedStart)));
        }
        return result.toString();
    }

    public static String shortenStackTraceForServletCall(String stackTrace) {
        return ExceptionUtil.shortenStackTrace(stackTrace, "javax.servlet.http.HttpServlet.service");
    }

    public static Throwable withServletContainerStackOmitted(Throwable t) {
        if (t == null) {
            return null;
        }
        return new Throwable(t){

            @Override
            public synchronized void printStackTrace(PrintStream out) {
                out.print(this.getShortenedStackTrace());
            }

            @Override
            public synchronized void printStackTrace(PrintWriter out) {
                out.print(this.getShortenedStackTrace());
            }

            @Override
            public synchronized Throwable fillInStackTrace() {
                return this;
            }

            private String getFullStackTrace() {
                StringWriter writer = new StringWriter();
                this.getCause().printStackTrace(new PrintWriter(writer));
                return writer.getBuffer().toString();
            }

            private String getShortenedStackTrace() {
                return ExceptionUtil.shortenStackTraceForServletCall(this.getFullStackTrace());
            }
        };
    }
}

