/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.jenax.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.topbraid.jenax.util.JenaUtil;

public class ExtraPrefixes {
    private static Map<String, String> map = new HashMap<String, String>();

    public static void add(String prefix, String namespace) {
        if (!map.containsKey(prefix)) {
            map.put(prefix, namespace);
        }
    }

    public static void add(Resource resource) {
        String ns = resource.getNameSpace();
        String prefix = resource.getModel().getNsURIPrefix(ns);
        if (prefix != null && prefix.length() > 0) {
            ExtraPrefixes.add(prefix, ns);
        }
    }

    public static PrefixMapping createPrefixMappingWithExtraPrefixes(Model model) {
        PrefixMappingImpl pm = new PrefixMappingImpl();
        String defaultNamespace = JenaUtil.getNsPrefixURI(model, "");
        if (defaultNamespace != null) {
            pm.setNsPrefix("", defaultNamespace);
        }
        Map<String, String> extraPrefixes = ExtraPrefixes.getExtraPrefixes();
        for (String prefix : extraPrefixes.keySet()) {
            String ns = extraPrefixes.get(prefix);
            if (ns == null || pm.getNsPrefixURI(prefix) != null) continue;
            pm.setNsPrefix(prefix, ns);
        }
        Map map = model.getNsPrefixMap();
        map.remove("");
        pm.setNsPrefixes(map);
        return pm;
    }

    public static Map<String, String> getExtraPrefixes() {
        return map;
    }

    static {
        map.put("afn", "http://jena.hpl.hp.com/ARQ/function#");
        map.put("fn", "http://www.w3.org/2005/xpath-functions#");
        map.put("jfn", "java:org.apache.jena.sparql.function.library.");
        map.put("list", "http://jena.apache.org/ARQ/list#");
        map.put("pf", "http://jena.hpl.hp.com/ARQ/property#");
        map.put("smf", "http://topbraid.org/sparqlmotionfunctions#");
        map.put("tops", "http://www.topbraid.org/tops#");
    }
}

