/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.expr.lib;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.topbraid.shacl.expr.AbstractInputExpression;
import org.topbraid.shacl.expr.NodeExpression;
import org.topbraid.shacl.expr.NodeExpressionContext;
import org.topbraid.shacl.expr.NodeExpressionVisitor;

public class MinusExpression
extends AbstractInputExpression {
    private NodeExpression minus;

    public MinusExpression(RDFNode expr, NodeExpression nodes, NodeExpression minus) {
        super(expr, nodes);
        this.minus = minus;
    }

    @Override
    public ExtendedIterator<RDFNode> eval(RDFNode focusNode, NodeExpressionContext context) {
        Set sans = this.minus.eval(focusNode, context).toSet();
        return this.getInput().eval(focusNode, context).filterDrop(n -> sans.contains(n));
    }

    @Override
    public List<String> getFunctionalSyntaxArguments() {
        LinkedList<String> results = new LinkedList<String>();
        results.add(this.getInput().getFunctionalSyntax());
        results.add(this.minus.getFunctionalSyntax());
        return results;
    }

    @Override
    public List<NodeExpression> getInputExpressions() {
        return Arrays.asList(this.getInput(), this.minus);
    }

    @Override
    public Resource getOutputShape(Resource contextShape) {
        return this.getInput().getOutputShape(contextShape);
    }

    @Override
    public String getTypeId() {
        return "minus";
    }

    @Override
    public void visit(NodeExpressionVisitor visitor) {
        visitor.visit(this);
    }
}

