/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.testcases;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import org.apache.jena.graph.Graph;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.topbraid.jenax.functions.CurrentThreadFunctionRegistry;
import org.topbraid.jenax.util.ARQFactory;
import org.topbraid.jenax.util.JenaDatatypes;
import org.topbraid.jenax.util.JenaUtil;
import org.topbraid.shacl.testcases.TestCase;
import org.topbraid.shacl.testcases.TestCaseType;
import org.topbraid.shacl.testcases.context.TestCaseContext;
import org.topbraid.shacl.testcases.context.TestCaseContextFactory;
import org.topbraid.shacl.vocabulary.DASH;

public class FunctionTestCaseType
extends TestCaseType {
    private static List<TestCaseContextFactory> contextFactories = new LinkedList<TestCaseContextFactory>();

    public static void registerContextFactory(TestCaseContextFactory factory) {
        contextFactories.add(factory);
    }

    public FunctionTestCaseType() {
        super(DASH.FunctionTestCase);
    }

    @Override
    protected TestCase createTestCase(Resource graph, Resource resource) {
        return new FunctionTestCase(graph, resource);
    }

    private static class FunctionTestCase
    extends TestCase {
        FunctionTestCase(Resource graph, Resource resource) {
            super(graph, resource);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run(Model results) {
            Resource testCase = this.getResource();
            Runnable tearDownCTFR = CurrentThreadFunctionRegistry.register(testCase.getModel());
            try {
                for (TestCaseContextFactory contextFactory : contextFactories) {
                    TestCaseContext context = contextFactory.createContext();
                    String expression = JenaUtil.getStringProperty(testCase, DASH.expression);
                    Statement expectedResultS = testCase.getProperty(DASH.expectedResult);
                    String queryString = "SELECT (" + expression + " AS ?result) WHERE {}";
                    Query query = ARQFactory.get().createQuery(testCase.getModel(), queryString);
                    context.setUpTestContext();
                    try {
                        QueryExecution qexec = ARQFactory.get().createQueryExecution(query, testCase.getModel());
                        try {
                            ResultSet rs = qexec.execSelect();
                            if (!rs.hasNext()) {
                                if (expectedResultS == null) continue;
                                this.createFailure(results, "Expression returned no result, but expected: " + expectedResultS.getObject(), context);
                                return;
                            }
                            RDFNode actual = rs.next().get("result");
                            if (expectedResultS == null) {
                                if (actual == null) continue;
                                this.createFailure(results, "Expression returned a result, but none expected: " + actual, context);
                                return;
                            }
                            if (testCase.hasProperty(DASH.expectedResultIsTTL, (RDFNode)JenaDatatypes.TRUE)) {
                                Graph actualGraph;
                                Graph expectedGraph = this.parseGraph(expectedResultS.getObject());
                                if (expectedGraph.isIsomorphicWith(actualGraph = this.parseGraph(actual))) continue;
                                this.createFailure(results, "Mismatching result graphs. Expected: " + expectedResultS.getObject() + ". Found: " + actual, context);
                                return;
                            }
                            if (expectedResultS.getObject().equals(actual)) continue;
                            this.createFailure(results, "Mismatching result. Expected: " + expectedResultS.getObject() + ". Found: " + actual, context);
                            return;
                        }
                        finally {
                            if (qexec == null) continue;
                            qexec.close();
                        }
                    }
                    finally {
                        context.tearDownTestContext();
                    }
                }
            }
            finally {
                tearDownCTFR.run();
            }
            this.createResult(results, DASH.SuccessTestCaseResult);
        }

        private Graph parseGraph(RDFNode node) {
            Model model = JenaUtil.createDefaultModel();
            if (node.isLiteral()) {
                String str = node.asLiteral().getLexicalForm();
                model.read((InputStream)new ByteArrayInputStream(str.getBytes()), "urn:x:dummy", "TURTLE");
            }
            return model.getGraph();
        }
    }
}

