/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.testcases;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import java.util.List;
import org.apache.jena.atlas.json.JSON;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.impl.RDFjson;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.topbraid.jenax.functions.CurrentThreadFunctionRegistry;
import org.topbraid.jenax.util.ARQFactory;
import org.topbraid.jenax.util.ExceptionUtil;
import org.topbraid.jenax.util.JenaUtil;
import org.topbraid.shacl.multifunctions.MultiFunctions;
import org.topbraid.shacl.testcases.TestCase;
import org.topbraid.shacl.testcases.TestCaseType;
import org.topbraid.shacl.testcases.context.TestCaseContext;
import org.topbraid.shacl.testcases.context.TestCaseContextFactory;
import org.topbraid.shacl.vocabulary.DASH;
import org.topbraid.shacl.vocabulary.SH;

public class QueryTestCaseType
extends TestCaseType {
    private static List<TestCaseContextFactory> contextFactories = new LinkedList<TestCaseContextFactory>();

    public static void registerContextFactory(TestCaseContextFactory factory) {
        contextFactories.add(factory);
    }

    public static String createResultSetJSON(String queryString, Model model) {
        Runnable tearDownCTFR = CurrentThreadFunctionRegistry.register(model);
        try {
            String string;
            block11: {
                Query query = ARQFactory.get().createQuery(model, queryString);
                QueryExecution qexec = ARQFactory.get().createQueryExecution(query, model);
                try {
                    ResultSet actualResults = qexec.execSelect();
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    ResultSetFormatter.outputAsJSON((OutputStream)os, (ResultSet)actualResults);
                    string = os.toString("UTF-8");
                    if (qexec == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (qexec != null) {
                            try {
                                qexec.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (UnsupportedEncodingException e) {
                        throw ExceptionUtil.throwUnchecked(e);
                    }
                }
                qexec.close();
            }
            return string;
        }
        finally {
            tearDownCTFR.run();
        }
    }

    public QueryTestCaseType() {
        super(DASH.QueryTestCase);
    }

    @Override
    protected TestCase createTestCase(Resource graph, Resource resource) {
        return new QueryTestCase(graph, resource);
    }

    private static class QueryTestCase
    extends TestCase {
        QueryTestCase(Resource graph, Resource resource) {
            super(graph, resource);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run(Model results) throws Exception {
            Iterable<String> tempURIs = MultiFunctions.registerAllTemp(this.getResource().getModel());
            try {
                Resource testCase = this.getResource();
                String queryString = JenaUtil.getStringProperty(testCase, SH.select);
                Model model = testCase.getModel();
                JsonObject expectedJSON = JSON.parse((String)JenaUtil.getStringProperty(testCase, DASH.expectedResult));
                for (TestCaseContextFactory contextFactory : contextFactories) {
                    TestCaseContext context = contextFactory.createContext();
                    context.setUpTestContext();
                    try {
                        String actual = QueryTestCaseType.createResultSetJSON(queryString, model);
                        JsonObject actualJSON = JSON.parse((String)actual);
                        if (actualJSON.equals((Object)expectedJSON)) continue;
                        System.err.println("---- Test failure: " + testCase);
                        System.err.println(queryString);
                        System.err.println("---- Expected ----");
                        System.err.println(expectedJSON);
                        System.err.println("---- Actual ----");
                        System.err.println(actual);
                        System.err.println("----");
                        Resource failure = this.createFailure(results, "Mismatching query result set", context);
                        failure.addProperty(DASH.actualResult, (RDFNode)ResourceFactory.createTypedLiteral((String)actualJSON.toString(), (RDFDatatype)RDFjson.rdfJSON));
                        return;
                    }
                    finally {
                        context.tearDownTestContext();
                    }
                }
                this.createResult(results, DASH.SuccessTestCaseResult);
            }
            finally {
                tempURIs.forEach(uri -> MultiFunctions.unregister(uri));
            }
        }
    }
}

