/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.validation.sparql;

import java.util.HashSet;
import java.util.List;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.topbraid.jenax.util.JenaUtil;
import org.topbraid.shacl.engine.Constraint;
import org.topbraid.shacl.model.SHParameter;
import org.topbraid.shacl.validation.sparql.AbstractSPARQLExecutor;
import org.topbraid.shacl.validation.sparql.SPARQLSubstitutions;
import org.topbraid.shacl.validation.sparql.SPARQLSyntaxChecker;
import org.topbraid.shacl.vocabulary.SH;

public class SPARQLComponentExecutor
extends AbstractSPARQLExecutor {
    private boolean wasAsk;

    public SPARQLComponentExecutor(Constraint constraint) {
        super(constraint);
        if (!"http://www.w3.org/ns/shacl#".equals(constraint.getComponent().getNameSpace())) {
            List<String> errors;
            HashSet<String> preBoundVars = new HashSet<String>();
            for (SHParameter param : constraint.getComponent().getParameters()) {
                preBoundVars.add(param.getVarName());
            }
            preBoundVars.add(SH.thisVar.getVarName());
            preBoundVars.add(SH.shapesGraphVar.getVarName());
            preBoundVars.add(SH.currentShapeVar.getVarName());
            if (this.wasAsk) {
                preBoundVars.add(SH.valueVar.getVarName());
            }
            if (!(errors = SPARQLSyntaxChecker.checkQuery(this.getQuery(), preBoundVars)).isEmpty()) {
                throw new IllegalArgumentException(errors.size() + " violations of SPARQL Syntax rules (Appendix A): " + errors + ". Query: " + this.getQuery());
            }
        }
    }

    @Override
    protected void addBindings(Constraint constraint, QuerySolutionMap bindings) {
        constraint.addBindings(bindings);
    }

    @Override
    protected String getLabel(Constraint constraint) {
        return constraint.getComponent().getLocalName() + " (SPARQL constraint component executor)";
    }

    @Override
    protected String getSPARQL(Constraint constraint) {
        Resource validator = constraint.getComponent().getValidator(SH.SPARQLExecutable, constraint.getContext());
        if (JenaUtil.hasIndirectType(validator, SH.SPARQLAskValidator)) {
            return this.createSPARQLFromAskValidator(constraint, validator);
        }
        if (JenaUtil.hasIndirectType(validator, SH.SPARQLSelectValidator)) {
            return SPARQLSubstitutions.withPrefixes(JenaUtil.getStringProperty(validator, SH.select), validator);
        }
        return null;
    }

    @Override
    protected Resource getSPARQLExecutable(Constraint constraint) {
        return constraint.getComponent().getValidator(SH.SPARQLExecutable, constraint.getContext());
    }

    private String createSPARQLFromAskValidator(Constraint constraint, Resource validator) {
        this.wasAsk = true;
        Object valueVar = "?value";
        while (constraint.getComponent().getParametersMap().containsKey(valueVar)) {
            valueVar = (String)valueVar + "_";
        }
        StringBuffer sb = new StringBuffer();
        if (SH.NodeShape.equals((Object)constraint.getContext())) {
            sb.append("SELECT $this ?value\nWHERE {\n");
            sb.append("    BIND ($this AS ");
            sb.append((String)valueVar);
            sb.append(") .\n");
        } else {
            sb.append("SELECT DISTINCT $this ?value");
            HashSet<String> otherVarNames = new HashSet<String>();
            for (Statement messageS : validator.listProperties(SH.message).toList()) {
                SPARQLSubstitutions.addMessageVarNames(messageS.getLiteral().getLexicalForm(), otherVarNames);
            }
            otherVarNames.remove(SH.pathVar.getVarName());
            otherVarNames.remove(SH.valueVar.getVarName());
            for (String varName : otherVarNames) {
                sb.append(" ?" + varName);
            }
            sb.append("\nWHERE {\n");
            sb.append("    $this $" + SH.PATHVar.getVarName() + " " + (String)valueVar + " .\n");
        }
        String sparql = JenaUtil.getStringProperty(validator, SH.ask);
        int firstIndex = sparql.indexOf(123);
        int lastIndex = sparql.lastIndexOf(125);
        String body = "{" + sparql.substring(firstIndex + 1, lastIndex + 1);
        sb.append("    FILTER NOT EXISTS " + body + "\n}");
        return SPARQLSubstitutions.withPrefixes(sb.toString(), validator);
    }
}

