/*
 * Decompiled with CFR 0.152.
 */
package org.torquebox.mojo.mavengem;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.NoSuchFileException;
import org.sonatype.nexus.ruby.GemArtifactFile;
import org.sonatype.nexus.ruby.RubygemsFile;
import org.torquebox.mojo.mavengem.Rubygems;
import org.torquebox.mojo.mavengem.RubygemsFactory;

public class MavenGemURLConnection
extends URLConnection {
    public static final String MAVEN_RELEASES = "/maven/releases";
    public static final String PING = "/maven/releases/ping";
    private InputStream in;
    private long timestamp = -1L;
    final URL baseurl;
    final String path;
    final RubygemsFactory factory;
    private int counter = 12;

    public static MavenGemURLConnection create(String uri) throws MalformedURLException {
        return MavenGemURLConnection.create(null, uri);
    }

    public static MavenGemURLConnection create(RubygemsFactory factory, String uri) throws MalformedURLException {
        int index = uri.indexOf(MAVEN_RELEASES);
        String path = uri.substring(index);
        String baseurl = uri.substring(0, index);
        return new MavenGemURLConnection(factory, new URL(baseurl), path);
    }

    public MavenGemURLConnection(URL baseurl, String path) throws MalformedURLException {
        this(null, baseurl, path);
    }

    public MavenGemURLConnection(RubygemsFactory factory, URL baseurl, String path) throws MalformedURLException {
        super(baseurl);
        this.factory = factory == null ? RubygemsFactory.defaultFactory() : factory;
        this.baseurl = baseurl;
        this.path = path.startsWith(MAVEN_RELEASES) ? path : MAVEN_RELEASES + path;
    }

    @Override
    public synchronized InputStream getInputStream() throws IOException {
        if (this.in == null) {
            this.connect();
        }
        return this.in;
    }

    public synchronized long getModified() throws IOException {
        if (this.timestamp == -1L) {
            this.connect();
        }
        return this.timestamp;
    }

    @Override
    public synchronized void connect() throws IOException {
        this.connect(this.factory.getOrCreate(this.baseurl));
    }

    private void connect(Rubygems facade) throws IOException {
        RubygemsFile file = facade.get(this.path);
        switch (file.state()) {
            case FORBIDDEN: {
                throw new IOException("forbidden: " + file + " on " + this.baseurl);
            }
            case NOT_EXISTS: {
                if (this.path.equals(PING)) {
                    this.in = new ByteArrayInputStream("pong".getBytes());
                    break;
                }
                throw new FileNotFoundException(file.toString() + " on " + this.baseurl);
            }
            case NO_PAYLOAD: {
                switch (file.type()) {
                    case GEM_ARTIFACT: {
                        this.in = new URL(this.baseurl + "/gems/" + ((GemArtifactFile)file).gem(null).filename() + ".gem").openStream();
                    }
                    case GEM: {
                        this.in = new URL(this.baseurl + "/" + file.remotePath()).openStream();
                    }
                }
                throw new FileNotFoundException("view - not implemented. " + file + " on " + this.baseurl + " on " + this.baseurl);
            }
            case ERROR: {
                if (file.getException() instanceof NoSuchFileException) {
                    throw new FileNotFoundException(file.toString() + " on " + this.baseurl);
                }
                throw new IOException(file.toString() + " on " + this.baseurl, file.getException());
            }
            case TEMP_UNAVAILABLE: {
                try {
                    Thread.currentThread();
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (--this.counter <= 0) break;
                this.connect(facade);
                break;
            }
            case PAYLOAD: {
                this.in = facade.getInputStream(file);
                this.timestamp = facade.getModified(file);
                break;
            }
            default: {
                throw new RuntimeException("BUG: should never reach here. " + file + " on " + this.baseurl);
            }
        }
    }
}

